/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.lang.reflect.Array;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.graphdb.spatial.CRS;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.BooleanArray;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.ByteArray;
import org.neo4j.values.storable.ByteValue;
import org.neo4j.values.storable.CharArray;
import org.neo4j.values.storable.CharValue;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DateArray;
import org.neo4j.values.storable.DateTimeArray;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DoubleArray;
import org.neo4j.values.storable.DoubleValue;
import org.neo4j.values.storable.DurationArray;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.FloatArray;
import org.neo4j.values.storable.FloatValue;
import org.neo4j.values.storable.FloatingPointValue;
import org.neo4j.values.storable.IntArray;
import org.neo4j.values.storable.IntValue;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.LocalDateTimeArray;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeArray;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.LongArray;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.NoValue;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.PointArray;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.ShortArray;
import org.neo4j.values.storable.ShortValue;
import org.neo4j.values.storable.StringArray;
import org.neo4j.values.storable.StringValue;
import org.neo4j.values.storable.StringWrappingStringValue;
import org.neo4j.values.storable.TemporalArray;
import org.neo4j.values.storable.TemporalValue;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.TimeArray;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.UTF8StringValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueComparator;
import org.neo4j.values.storable.ValueGroup;

public final class Values {
    public static final Value NO_VALUE = NoValue.NO_VALUE;
    public static final Value MIN_GLOBAL = DateTimeValue.MIN_VALUE;
    public static final Value MAX_GLOBAL = NO_VALUE;
    public static final Value MIN_NUMBER = Values.doubleValue(Double.NEGATIVE_INFINITY);
    public static final Value MAX_NUMBER = Values.doubleValue(Double.NaN);
    public static final Value ZERO_FLOAT = Values.doubleValue(0.0);
    public static final IntegralValue ZERO_INT = Values.longValue(0L);
    public static final Value MIN_STRING = StringValue.EMPTY;
    public static final Value MAX_STRING = Values.booleanValue(false);
    public static final BooleanValue TRUE = Values.booleanValue(true);
    public static final BooleanValue FALSE = Values.booleanValue(false);
    public static final TextValue EMPTY_STRING = StringValue.EMPTY;
    public static final DoubleValue E = Values.doubleValue(Math.E);
    public static final DoubleValue PI = Values.doubleValue(Math.PI);
    public static final DoubleValue NaN = Values.doubleValue(Double.NaN);
    public static final DoubleValue Infinity = Values.doubleValue(Double.POSITIVE_INFINITY);
    public static final DoubleValue NegInfinity = Values.doubleValue(Double.NEGATIVE_INFINITY);
    public static final ArrayValue EMPTY_SHORT_ARRAY = Values.shortArray(ArrayUtils.EMPTY_SHORT_ARRAY);
    public static final ArrayValue EMPTY_BOOLEAN_ARRAY = Values.booleanArray(ArrayUtils.EMPTY_BOOLEAN_ARRAY);
    public static final ArrayValue EMPTY_BYTE_ARRAY = Values.byteArray(ArrayUtils.EMPTY_BYTE_ARRAY);
    public static final ArrayValue EMPTY_CHAR_ARRAY = Values.charArray(ArrayUtils.EMPTY_CHAR_ARRAY);
    public static final ArrayValue EMPTY_INT_ARRAY = Values.intArray(ArrayUtils.EMPTY_INT_ARRAY);
    public static final ArrayValue EMPTY_LONG_ARRAY = Values.longArray(ArrayUtils.EMPTY_LONG_ARRAY);
    public static final ArrayValue EMPTY_FLOAT_ARRAY = Values.floatArray(ArrayUtils.EMPTY_FLOAT_ARRAY);
    public static final ArrayValue EMPTY_DOUBLE_ARRAY = Values.doubleArray(ArrayUtils.EMPTY_DOUBLE_ARRAY);
    public static final TextArray EMPTY_TEXT_ARRAY = Values.stringArray(new String[0]);
    public static final ValueComparator COMPARATOR = new ValueComparator(Enum::compareTo);

    private Values() {
    }

    public static boolean isNumberValue(Object value) {
        return value instanceof NumberValue;
    }

    public static boolean isBooleanValue(Object value) {
        return value instanceof BooleanValue;
    }

    public static boolean isTextValue(Object value) {
        return value instanceof TextValue;
    }

    public static boolean isArrayValue(Value value) {
        return value instanceof ArrayValue;
    }

    public static boolean isGeometryValue(Value value) {
        return value instanceof PointValue;
    }

    public static boolean isGeometryArray(Value value) {
        return value instanceof PointArray;
    }

    public static boolean isTemporalValue(Value value) {
        return value instanceof TemporalValue || value instanceof DurationValue;
    }

    public static boolean isTemporalArray(Value value) {
        return value instanceof TemporalArray || value instanceof DurationArray;
    }

    public static double coerceToDouble(Value value) {
        if (value instanceof IntegralValue) {
            IntegralValue integralValue = (IntegralValue)value;
            return integralValue.longValue();
        }
        if (value instanceof FloatingPointValue) {
            FloatingPointValue floatingPointValue = (FloatingPointValue)value;
            return floatingPointValue.doubleValue();
        }
        throw new UnsupportedOperationException(String.format("Cannot coerce %s to double", value));
    }

    public static TextValue utf8Value(String value) {
        return Values.utf8Value(value.getBytes(StandardCharsets.UTF_8));
    }

    public static Value ut8fOrNoValue(String value) {
        if (value == null) {
            return NO_VALUE;
        }
        return Values.utf8Value(value);
    }

    public static TextValue utf8Value(byte[] bytes) {
        if (bytes.length == 0) {
            return EMPTY_STRING;
        }
        return Values.utf8Value(bytes, 0, bytes.length);
    }

    public static TextValue utf8Value(byte[] bytes, int offset, int length) {
        if (length == 0) {
            return EMPTY_STRING;
        }
        return new UTF8StringValue(bytes, offset, length);
    }

    public static TextValue stringValue(String value) {
        if (value.isEmpty()) {
            return EMPTY_STRING;
        }
        return new StringWrappingStringValue(value);
    }

    public static Value stringOrNoValue(String value) {
        if (value == null) {
            return NO_VALUE;
        }
        return Values.stringValue(value);
    }

    public static NumberValue numberValue(Number number) {
        if (number instanceof Long) {
            Long longNumber = (Long)number;
            return Values.longValue(longNumber);
        }
        if (number instanceof Integer) {
            Integer intNumber = (Integer)number;
            return Values.intValue(intNumber);
        }
        if (number instanceof Double) {
            Double doubleNumber = (Double)number;
            return Values.doubleValue(doubleNumber);
        }
        if (number instanceof Byte) {
            Byte byteNumber = (Byte)number;
            return Values.byteValue(byteNumber);
        }
        if (number instanceof Float) {
            Float floatNumber = (Float)number;
            return Values.floatValue(floatNumber.floatValue());
        }
        if (number instanceof Short) {
            Short shortNumber = (Short)number;
            return Values.shortValue(shortNumber);
        }
        throw new UnsupportedOperationException("Unsupported type of Number " + number);
    }

    public static LongValue longValue(long value) {
        return new LongValue(value);
    }

    public static IntValue intValue(int value) {
        return new IntValue(value);
    }

    public static ShortValue shortValue(short value) {
        return new ShortValue(value);
    }

    public static ByteValue byteValue(byte value) {
        return new ByteValue(value);
    }

    public static BooleanValue booleanValue(boolean value) {
        return value ? BooleanValue.TRUE : BooleanValue.FALSE;
    }

    public static CharValue charValue(char value) {
        return new CharValue(value);
    }

    public static DoubleValue doubleValue(double value) {
        return new DoubleValue(value);
    }

    public static FloatValue floatValue(float value) {
        return new FloatValue(value);
    }

    public static TextArray stringArray(String ... value) {
        return new StringArray(value);
    }

    public static ByteArray byteArray(byte[] value) {
        return new ByteArray(value);
    }

    public static LongArray longArray(long[] value) {
        return new LongArray(value);
    }

    public static IntArray intArray(int[] value) {
        return new IntArray(value);
    }

    public static DoubleArray doubleArray(double[] value) {
        return new DoubleArray(value);
    }

    public static FloatArray floatArray(float[] value) {
        return new FloatArray(value);
    }

    public static BooleanArray booleanArray(boolean[] value) {
        return new BooleanArray(value);
    }

    public static CharArray charArray(char[] value) {
        return new CharArray(value);
    }

    public static ShortArray shortArray(short[] value) {
        return new ShortArray(value);
    }

    public static PointValue pointValue(CoordinateReferenceSystem crs, double ... coordinate) {
        return new PointValue(crs, coordinate);
    }

    public static PointValue point(Point point) {
        double[] coords = point.getCoordinate().getCoordinateCopy();
        return new PointValue(Values.crs(point.getCRS()), coords);
    }

    public static PointValue minPointValue(PointValue reference) {
        return PointValue.minPointValueOf(reference.getCoordinateReferenceSystem());
    }

    public static PointValue maxPointValue(PointValue reference) {
        return PointValue.maxPointValueOf(reference.getCoordinateReferenceSystem());
    }

    public static PointArray pointArray(Point[] points) {
        PointValue[] values = new PointValue[points.length];
        for (int i = 0; i < points.length; ++i) {
            values[i] = Values.point(points[i]);
        }
        return new PointArray(values);
    }

    public static PointArray pointArray(Value[] maybePoints) {
        PointValue[] values = new PointValue[maybePoints.length];
        for (int i = 0; i < maybePoints.length; ++i) {
            Value maybePoint = maybePoints[i];
            if (!(maybePoint instanceof PointValue)) {
                throw new IllegalArgumentException(String.format("[%s:%s] is not a supported point value", maybePoint, maybePoint.getClass().getName()));
            }
            values[i] = Values.point((PointValue)maybePoint);
        }
        return Values.pointArray(values);
    }

    public static PointArray pointArray(PointValue[] points) {
        return new PointArray(points);
    }

    public static CoordinateReferenceSystem crs(CRS crs) {
        return CoordinateReferenceSystem.get(crs);
    }

    public static Value temporalValue(Temporal value) {
        if (value instanceof ZonedDateTime) {
            ZonedDateTime zonedDateTime = (ZonedDateTime)value;
            return DateTimeValue.datetime(zonedDateTime);
        }
        if (value instanceof OffsetDateTime) {
            OffsetDateTime offsetDateTime = (OffsetDateTime)value;
            return DateTimeValue.datetime(offsetDateTime);
        }
        if (value instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)value;
            return LocalDateTimeValue.localDateTime(localDateTime);
        }
        if (value instanceof OffsetTime) {
            OffsetTime offsetTime = (OffsetTime)value;
            return TimeValue.time(offsetTime);
        }
        if (value instanceof LocalDate) {
            LocalDate localDate = (LocalDate)value;
            return DateValue.date(localDate);
        }
        if (value instanceof LocalTime) {
            LocalTime localTime = (LocalTime)value;
            return LocalTimeValue.localTime(localTime);
        }
        if (value instanceof TemporalValue) {
            TemporalValue temporalValue = (TemporalValue)value;
            return temporalValue;
        }
        if (value == null) {
            return NO_VALUE;
        }
        throw new UnsupportedOperationException("Unsupported type of Temporal " + value);
    }

    public static DurationValue durationValue(TemporalAmount value) {
        if (value instanceof Duration) {
            Duration duration = (Duration)value;
            return DurationValue.duration(duration);
        }
        if (value instanceof Period) {
            Period period = (Period)value;
            return DurationValue.duration(period);
        }
        if (value instanceof DurationValue) {
            DurationValue durationValue = (DurationValue)value;
            return durationValue;
        }
        DurationValue duration = DurationValue.duration(0L, 0L, 0L, 0L);
        for (TemporalUnit unit : value.getUnits()) {
            duration = duration.plus(value.get(unit), unit);
        }
        return duration;
    }

    public static DateTimeArray dateTimeArray(ZonedDateTime[] values) {
        return new DateTimeArray(values);
    }

    public static LocalDateTimeArray localDateTimeArray(LocalDateTime[] values) {
        return new LocalDateTimeArray(values);
    }

    public static LocalTimeArray localTimeArray(LocalTime[] values) {
        return new LocalTimeArray(values);
    }

    public static TimeArray timeArray(OffsetTime[] values) {
        return new TimeArray(values);
    }

    public static DateArray dateArray(LocalDate[] values) {
        return new DateArray(values);
    }

    public static DurationArray durationArray(DurationValue[] values) {
        return new DurationArray(values);
    }

    public static DurationArray durationArray(TemporalAmount[] values) {
        DurationValue[] durations = new DurationValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            durations[i] = Values.durationValue(values[i]);
        }
        return new DurationArray(durations);
    }

    public static Value of(Object value) {
        return Values.of(value, true);
    }

    public static Value of(Object value, boolean allowNull) {
        Value of = Values.unsafeOf(value, allowNull);
        if (of != null) {
            return of;
        }
        Objects.requireNonNull(value);
        throw new IllegalArgumentException(String.format("[%s:%s] is not a supported property value", value, value.getClass().getName()));
    }

    public static Value unsafeOf(Object value, boolean allowNull) {
        if (value == null) {
            if (allowNull) {
                return NO_VALUE;
            }
            throw new IllegalArgumentException("[null] is not a supported property value");
        }
        if (value instanceof String) {
            String string = (String)value;
            return Values.utf8Value(string.getBytes(StandardCharsets.UTF_8));
        }
        if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            return Values.arrayValue(array, true);
        }
        if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            return Values.booleanValue(bool);
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return Values.numberValue(number);
        }
        if (value instanceof Character) {
            Character character = (Character)value;
            return Values.charValue(character.charValue());
        }
        if (value instanceof Temporal) {
            Temporal temporal = (Temporal)value;
            return Values.temporalValue(temporal);
        }
        if (value instanceof TemporalAmount) {
            TemporalAmount temporalAmount = (TemporalAmount)value;
            return Values.durationValue(temporalAmount);
        }
        if (value instanceof byte[]) {
            byte[] byteArray = (byte[])value;
            return Values.byteArray(Arrays.copyOf(byteArray, byteArray.length));
        }
        if (value instanceof long[]) {
            long[] longArray = (long[])value;
            return Values.longArray(Arrays.copyOf(longArray, longArray.length));
        }
        if (value instanceof int[]) {
            int[] intArray = (int[])value;
            return Values.intArray(Arrays.copyOf(intArray, intArray.length));
        }
        if (value instanceof double[]) {
            double[] doubleArray = (double[])value;
            return Values.doubleArray(Arrays.copyOf(doubleArray, doubleArray.length));
        }
        if (value instanceof float[]) {
            float[] floatArray = (float[])value;
            return Values.floatArray(Arrays.copyOf(floatArray, floatArray.length));
        }
        if (value instanceof boolean[]) {
            boolean[] boolArray = (boolean[])value;
            return Values.booleanArray(Arrays.copyOf(boolArray, boolArray.length));
        }
        if (value instanceof char[]) {
            char[] charArray = (char[])value;
            return Values.charArray(Arrays.copyOf(charArray, charArray.length));
        }
        if (value instanceof short[]) {
            short[] shortArray = (short[])value;
            return Values.shortArray(Arrays.copyOf(shortArray, shortArray.length));
        }
        if (value instanceof Point) {
            Point point = (Point)value;
            return Values.point(point);
        }
        if (value instanceof Value) {
            throw new UnsupportedOperationException("Converting a Value to a Value using Values.of() is not supported.");
        }
        return null;
    }

    public static Value[] values(Object ... objects) {
        return (Value[])Arrays.stream(objects).map(Values::of).toArray(Value[]::new);
    }

    public static Object[] asObjects(Value[] propertyValues) {
        Object[] legacy = new Object[propertyValues.length];
        for (int i = 0; i < propertyValues.length; ++i) {
            legacy[i] = propertyValues[i].asObjectCopy();
        }
        return legacy;
    }

    public static Value arrayValue(Object[] value, boolean copyDefensively) {
        if (value instanceof String[]) {
            String[] array = (String[])value;
            return Values.stringArray(copyDefensively ? Values.copy(value, new String[value.length]) : array);
        }
        if (value instanceof Byte[]) {
            return Values.byteArray(Values.copy(value, new byte[value.length]));
        }
        if (value instanceof Long[]) {
            return Values.longArray(Values.copy(value, new long[value.length]));
        }
        if (value instanceof Integer[]) {
            return Values.intArray(Values.copy(value, new int[value.length]));
        }
        if (value instanceof Double[]) {
            return Values.doubleArray(Values.copy(value, new double[value.length]));
        }
        if (value instanceof Float[]) {
            return Values.floatArray(Values.copy(value, new float[value.length]));
        }
        if (value instanceof Boolean[]) {
            return Values.booleanArray(Values.copy(value, new boolean[value.length]));
        }
        if (value instanceof Character[]) {
            return Values.charArray(Values.copy(value, new char[value.length]));
        }
        if (value instanceof Short[]) {
            return Values.shortArray(Values.copy(value, new short[value.length]));
        }
        if (value instanceof PointValue[]) {
            PointValue[] array = (PointValue[])value;
            return Values.pointArray(copyDefensively ? Values.copy(value, new PointValue[value.length]) : array);
        }
        if (value instanceof Point[]) {
            Point[] array = (Point[])value;
            return Values.pointArray(array);
        }
        if (value instanceof ZonedDateTime[]) {
            ZonedDateTime[] array = (ZonedDateTime[])value;
            return Values.dateTimeArray(copyDefensively ? Values.copy(value, new ZonedDateTime[value.length]) : array);
        }
        if (value instanceof LocalDateTime[]) {
            LocalDateTime[] array = (LocalDateTime[])value;
            return Values.localDateTimeArray(copyDefensively ? Values.copy(value, new LocalDateTime[value.length]) : array);
        }
        if (value instanceof LocalTime[]) {
            LocalTime[] array = (LocalTime[])value;
            return Values.localTimeArray(copyDefensively ? Values.copy(value, new LocalTime[value.length]) : array);
        }
        if (value instanceof OffsetTime[]) {
            OffsetTime[] array = (OffsetTime[])value;
            return Values.timeArray(copyDefensively ? Values.copy(value, new OffsetTime[value.length]) : array);
        }
        if (value instanceof LocalDate[]) {
            LocalDate[] array = (LocalDate[])value;
            return Values.dateArray(copyDefensively ? Values.copy(value, new LocalDate[value.length]) : array);
        }
        if (value instanceof TemporalAmount[]) {
            TemporalAmount[] array = (TemporalAmount[])value;
            return Values.durationArray(array);
        }
        return null;
    }

    private static <T> T copy(Object[] value, T target) {
        for (int i = 0; i < value.length; ++i) {
            if (value[i] == null) {
                throw new IllegalArgumentException("Property array value elements may not be null.");
            }
            Array.set(target, i, value[i]);
        }
        return target;
    }

    public static Value minValue(ValueGroup valueGroup, Value value) {
        return switch (valueGroup) {
            case ValueGroup.TEXT -> MIN_STRING;
            case ValueGroup.NUMBER -> MIN_NUMBER;
            case ValueGroup.GEOMETRY -> Values.minPointValue((PointValue)value);
            case ValueGroup.DATE -> DateValue.MIN_VALUE;
            case ValueGroup.LOCAL_DATE_TIME -> LocalDateTimeValue.MIN_VALUE;
            case ValueGroup.ZONED_DATE_TIME -> DateTimeValue.MIN_VALUE;
            case ValueGroup.LOCAL_TIME -> LocalTimeValue.MIN_VALUE;
            case ValueGroup.ZONED_TIME -> TimeValue.MIN_VALUE;
            default -> throw new IllegalStateException(String.format("The minValue for valueGroup %s is not defined yet", new Object[]{valueGroup}));
        };
    }

    public static Value maxValue(ValueGroup valueGroup, Value value) {
        return switch (valueGroup) {
            case ValueGroup.TEXT -> MAX_STRING;
            case ValueGroup.NUMBER -> MAX_NUMBER;
            case ValueGroup.GEOMETRY -> Values.maxPointValue((PointValue)value);
            case ValueGroup.DATE -> DateValue.MAX_VALUE;
            case ValueGroup.LOCAL_DATE_TIME -> LocalDateTimeValue.MAX_VALUE;
            case ValueGroup.ZONED_DATE_TIME -> DateTimeValue.MAX_VALUE;
            case ValueGroup.LOCAL_TIME -> LocalTimeValue.MAX_VALUE;
            case ValueGroup.ZONED_TIME -> TimeValue.MAX_VALUE;
            default -> throw new IllegalStateException(String.format("The maxValue for valueGroup %s is not defined yet", new Object[]{valueGroup}));
        };
    }
}

