/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.virtual;

import java.util.Comparator;
import java.util.function.Consumer;
import org.neo4j.exceptions.IncomparableValuesException;
import org.neo4j.values.AnyValue;
import org.neo4j.values.Comparison;
import org.neo4j.values.TernaryComparator;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.VirtualValue;
import org.neo4j.values.virtual.CompositeDatabaseValue;
import org.neo4j.values.virtual.RelationshipValue;
import org.neo4j.values.virtual.RelationshipVisitor;
import org.neo4j.values.virtual.VirtualValueGroup;

public abstract class VirtualRelationshipValue
extends VirtualValue {
    public abstract long id();

    public abstract long startNodeId(Consumer<RelationshipVisitor> var1);

    public abstract long endNodeId(Consumer<RelationshipVisitor> var1);

    public final long otherNodeId(long node, Consumer<RelationshipVisitor> consumer) {
        long startNodeId = this.startNodeId(consumer);
        return node == startNodeId ? this.endNodeId(consumer) : startNodeId;
    }

    public abstract int relationshipTypeId(Consumer<RelationshipVisitor> var1);

    @Override
    public int unsafeCompareTo(VirtualValue other, Comparator<AnyValue> comparator) {
        VirtualRelationshipValue otherNode = (VirtualRelationshipValue)other;
        return Long.compare(this.id(), otherNode.id());
    }

    @Override
    public Comparison unsafeTernaryCompareTo(VirtualValue other, TernaryComparator<AnyValue> comparator) {
        return Comparison.from(this.unsafeCompareTo(other, comparator));
    }

    @Override
    protected int computeHashToMemoize() {
        return Long.hashCode(this.id());
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapRelationship(this);
    }

    @Override
    public boolean equals(VirtualValue other) {
        if (!(other instanceof VirtualRelationshipValue)) {
            return false;
        }
        VirtualRelationshipValue that = (VirtualRelationshipValue)other;
        if (!(this instanceof RelationshipValue) && other instanceof CompositeDatabaseValue) {
            throw new IncomparableValuesException(this.getClass().getSimpleName(), other.getClass().getSimpleName());
        }
        return this.id() == that.id();
    }

    @Override
    public VirtualValueGroup valueGroup() {
        return VirtualValueGroup.EDGE;
    }
}

