/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.util.Arrays;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.IntegralArray;
import org.neo4j.values.storable.NumberValues;
import org.neo4j.values.storable.PrimitiveArrayValues;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;

public final class ByteArray
extends IntegralArray {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(ByteArray.class);
    private final byte[] value;
    private boolean invalid;

    ByteArray(byte[] value) {
        assert (value != null);
        this.value = value;
    }

    private void checkValid() {
        if (this.invalid) {
            throw new RuntimeException("Invalidated");
        }
    }

    @Override
    public int length() {
        this.checkValid();
        return this.value.length;
    }

    @Override
    public long longValue(int index) {
        this.checkValid();
        return this.value[index];
    }

    @Override
    protected int computeHashToMemoize() {
        this.checkValid();
        return NumberValues.hash(this.value);
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        this.checkValid();
        return mapper.mapByteArray(this);
    }

    @Override
    public boolean equals(Value other) {
        this.checkValid();
        return other.equals(this.value);
    }

    @Override
    public boolean equals(byte[] x) {
        this.checkValid();
        return Arrays.equals(this.value, x);
    }

    @Override
    public boolean equals(short[] x) {
        this.checkValid();
        return PrimitiveArrayValues.equals(this.value, x);
    }

    @Override
    public boolean equals(int[] x) {
        this.checkValid();
        return PrimitiveArrayValues.equals(this.value, x);
    }

    @Override
    public boolean equals(long[] x) {
        this.checkValid();
        return PrimitiveArrayValues.equals(this.value, x);
    }

    @Override
    public boolean equals(float[] x) {
        this.checkValid();
        return PrimitiveArrayValues.equals(this.value, x);
    }

    @Override
    public boolean equals(double[] x) {
        this.checkValid();
        return PrimitiveArrayValues.equals(this.value, x);
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        this.checkValid();
        writer.writeByteArray(this.value);
    }

    public byte[] asObjectCopy() {
        this.checkValid();
        return Arrays.copyOf(this.value, this.value.length);
    }

    @Deprecated
    public byte[] asObject() {
        this.checkValid();
        return this.value;
    }

    @Override
    public String prettyPrint() {
        this.checkValid();
        return Arrays.toString(this.value);
    }

    @Override
    public AnyValue value(int offset) {
        this.checkValid();
        return Values.byteValue(this.value[offset]);
    }

    public String toString() {
        this.checkValid();
        return String.format("%s%s", this.getTypeName(), Arrays.toString(this.value));
    }

    @Override
    public String getTypeName() {
        return "ByteArray";
    }

    public long estimatedHeapUsage() {
        return SHALLOW_SIZE + HeapEstimator.sizeOf((byte[])this.value);
    }

    public void zero() {
        this.invalid = true;
        Arrays.fill(this.value, (byte)0);
    }
}

