/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.hashing.HashFunction;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.StringWrappingStringValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.ListValueBuilder;
import org.neo4j.values.virtual.VirtualValues;

public abstract class StringValue
extends TextValue {
    static final TextValue EMPTY = new StringValue(){

        @Override
        protected int computeHashToMemoize() {
            return 0;
        }

        @Override
        public long updateHash(HashFunction hashFunction, long hash) {
            return hashFunction.update(hash, 0L);
        }

        @Override
        public int length() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public TextValue substring(int start, int end) {
            return this;
        }

        @Override
        public TextValue trim() {
            return this;
        }

        @Override
        public TextValue ltrim() {
            return this;
        }

        @Override
        public TextValue rtrim() {
            return this;
        }

        @Override
        public TextValue reverse() {
            return this;
        }

        @Override
        public TextValue plus(TextValue other) {
            return other;
        }

        @Override
        public boolean startsWith(TextValue other) {
            return other.length() == 0;
        }

        @Override
        public boolean endsWith(TextValue other) {
            return other.length() == 0;
        }

        @Override
        public boolean contains(TextValue other) {
            return other.length() == 0;
        }

        @Override
        public TextValue toLower() {
            return this;
        }

        @Override
        public TextValue toUpper() {
            return this;
        }

        @Override
        public TextValue replace(String find, String replace) {
            if (find.isEmpty()) {
                return Values.stringValue(replace);
            }
            return this;
        }

        @Override
        public int compareTo(TextValue other) {
            return -other.length();
        }

        @Override
        Matcher matcher(Pattern pattern) {
            return pattern.matcher("");
        }

        @Override
        String value() {
            return "";
        }

        public long estimatedHeapUsage() {
            return 0L;
        }
    };

    abstract String value();

    @Override
    public boolean equals(Value value) {
        return value.equals(this.value());
    }

    @Override
    public boolean equals(char x) {
        return this.value().length() == 1 && this.value().charAt(0) == x;
    }

    @Override
    public boolean equals(String x) {
        return this.value().equals(x);
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        writer.writeString(this.value());
    }

    @Override
    public TextValue toLower() {
        return new StringWrappingStringValue(this.value().toLowerCase());
    }

    @Override
    public TextValue toUpper() {
        return new StringWrappingStringValue(this.value().toUpperCase());
    }

    @Override
    public ListValue split(String separator) {
        assert (separator != null);
        String asString = this.value();
        if (separator.equals(asString)) {
            return EMPTY_SPLIT;
        }
        if (separator.isEmpty()) {
            return this.splitOnEmptySeparator(asString);
        }
        return StringValue.splitNonRegex(asString, separator);
    }

    private ListValue splitOnEmptySeparator(String asString) {
        char[] charArray = asString.toCharArray();
        String[] strArray = new String[charArray.length];
        for (int i = 0; i < charArray.length; ++i) {
            strArray[i] = String.valueOf(charArray[i]);
        }
        return VirtualValues.fromArray(Values.stringArray(strArray));
    }

    @Override
    public ListValue split(List<String> separators) {
        assert (separators != null);
        String asString = this.value();
        if (separators.stream().anyMatch(sep -> sep.equals(asString))) {
            return EMPTY_SPLIT;
        }
        if (separators.stream().anyMatch(String::isEmpty)) {
            String reduced = asString;
            for (String sep2 : separators) {
                if (sep2.isEmpty()) continue;
                reduced = reduced.replace(sep2, "");
            }
            return VirtualValues.fromArray(Values.charArray(reduced.toCharArray()));
        }
        return StringValue.splitNonRegex(asString, separators);
    }

    private static ListValue splitNonRegex(String input, String delim) {
        int index;
        ListValueBuilder substrings = ListValueBuilder.newListBuilder();
        int offset = 0;
        do {
            index = input.indexOf(delim, offset);
            offset = StringValue.updateSubstringsAndOffset(substrings, offset, input, index, delim);
        } while (index != -1);
        return substrings.build();
    }

    private static ListValue splitNonRegex(String input, List<String> delims) {
        Pair<Integer, String> nextSubstring;
        ListValueBuilder substrings = ListValueBuilder.newListBuilder();
        int offset = 0;
        do {
            nextSubstring = StringValue.firstIndexOf(input, offset, delims);
            offset = StringValue.updateSubstringsAndOffset(substrings, offset, input, (Integer)nextSubstring.first(), (String)nextSubstring.other());
        } while ((Integer)nextSubstring.first() != -1);
        return substrings.build();
    }

    private static int updateSubstringsAndOffset(ListValueBuilder substrings, int offset, String input, int index, String delim) {
        if (index == -1) {
            String substring = input.substring(offset);
            substrings.add(Values.stringValue(substring));
        } else {
            String substring = input.substring(offset, index);
            substrings.add(Values.stringValue(substring));
            offset = index + delim.length();
        }
        return offset;
    }

    private static Pair<Integer, String> firstIndexOf(String input, int offset, List<String> delims) {
        int firstIndex = -1;
        String first = null;
        for (String delim : delims) {
            int index = input.indexOf(delim, offset);
            if (index == -1 || first != null && index >= firstIndex) continue;
            first = delim;
            firstIndex = index;
        }
        return Pair.of((Object)firstIndex, first);
    }

    @Override
    public TextValue replace(String find, String replace) {
        assert (find != null);
        assert (replace != null);
        return Values.stringValue(this.value().replace(find, replace));
    }

    @Override
    public Object asObjectCopy() {
        return this.value();
    }

    public String toString() {
        return String.format("%s(\"%s\")", this.getTypeName(), this.value());
    }

    @Override
    public String getTypeName() {
        return "String";
    }

    @Override
    public String stringValue() {
        return this.value();
    }

    @Override
    public String prettyPrint() {
        return String.format("'%s'", this.value());
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapString(this);
    }

    @Override
    public int compareTo(TextValue other) {
        String thisString = this.value();
        String thatString = other.stringValue();
        return thisString.compareTo(thatString);
    }

    @Override
    public boolean isSameValueTypeAs(Value value) {
        return value instanceof StringValue;
    }
}

