/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.time.LocalDate;
import java.util.Arrays;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.TemporalArray;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueWriter;

public final class DateArray
extends TemporalArray<LocalDate> {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(DateArray.class);
    private final LocalDate[] value;

    DateArray(LocalDate[] value) {
        assert (value != null);
        this.value = value;
    }

    protected LocalDate[] value() {
        return this.value;
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapDateArray(this);
    }

    @Override
    public boolean equals(Value other) {
        return other.equals(this.value);
    }

    @Override
    public boolean equals(LocalDate[] x) {
        return Arrays.equals(this.value, x);
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        this.writeTo(writer, ValueWriter.ArrayType.DATE, this.value);
    }

    @Override
    public ValueGroup valueGroup() {
        return ValueGroup.DATE_ARRAY;
    }

    @Override
    int unsafeCompareTo(Value otherValue) {
        return this.compareToNonPrimitiveArray((DateArray)otherValue);
    }

    @Override
    public String getTypeName() {
        return "DateArray";
    }

    public long estimatedHeapUsage() {
        return SHALLOW_SIZE + HeapEstimator.sizeOfObjectArray((long)HeapEstimator.LOCAL_DATE_SIZE, (int)this.value.length);
    }
}

