/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.virtual;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.StreamSupport;
import org.neo4j.function.ThrowingBiConsumer;
import org.neo4j.internal.helpers.collection.PrefetchingIterator;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.Comparison;
import org.neo4j.values.Equality;
import org.neo4j.values.TernaryComparator;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.VirtualValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.VirtualValueGroup;
import org.neo4j.values.virtual.VirtualValues;

public abstract class MapValue
extends VirtualValue {
    public static final MapValue EMPTY = new MapValue(){

        @Override
        public Iterable<String> keySet() {
            return Collections.emptyList();
        }

        @Override
        public <E extends Exception> void foreach(ThrowingBiConsumer<String, AnyValue, E> f) {
        }

        @Override
        public boolean containsKey(String key) {
            return false;
        }

        @Override
        public AnyValue get(String key) {
            return Values.NO_VALUE;
        }

        @Override
        public int size() {
            return 0;
        }

        public long estimatedHeapUsage() {
            return 0L;
        }
    };
    private static final long MAP_WRAPPING_MAP_VALUE_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(MapWrappingMapValue.class);
    private static final long FILTERING_MAP_VALUE_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(FilteringMapValue.class);
    private static final long MAPPED_MAP_VALUE_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(MappedMapValue.class);
    private static final long UPDATED_MAP_VALUE_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(UpdatedMapValue.class);
    private static final long COMBINED_MAP_VALUE_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(CombinedMapValue.class);

    @Override
    protected int computeHashToMemoize() {
        int[] h = new int[1];
        this.foreach((key, value) -> {
            h[0] = h[0] + (key.hashCode() ^ value.hashCode());
        });
        return h[0];
    }

    @Override
    public <E extends Exception> void writeTo(AnyValueWriter<E> writer) throws E {
        writer.beginMap(this.size());
        this.foreach((s, anyValue) -> {
            writer.writeString((String)s);
            anyValue.writeTo(writer);
        });
        writer.endMap();
    }

    @Override
    public boolean equals(VirtualValue other) {
        if (!(other instanceof MapValue)) {
            return false;
        }
        MapValue that = (MapValue)other;
        int size = this.size();
        if (size != that.size()) {
            return false;
        }
        Iterable<String> keys = this.keySet();
        for (String key : keys) {
            if (this.get(key).equals(that.get(key))) continue;
            return false;
        }
        return true;
    }

    public abstract Iterable<String> keySet();

    public ListValue keys() {
        String[] keys = new String[this.size()];
        int i = 0;
        for (String key : this.keySet()) {
            keys[i++] = key;
        }
        return VirtualValues.fromArray(Values.stringArray(keys));
    }

    @Override
    public VirtualValueGroup valueGroup() {
        return VirtualValueGroup.MAP;
    }

    @Override
    public int unsafeCompareTo(VirtualValue other, Comparator<AnyValue> comparator) {
        MapValue otherMap = (MapValue)other;
        int size = this.size();
        int compare = Integer.compare(size, otherMap.size());
        if (compare == 0) {
            int i;
            String[] thisKeys = (String[])StreamSupport.stream(this.keySet().spliterator(), false).toArray(String[]::new);
            Arrays.sort(thisKeys, String::compareTo);
            String[] thatKeys = (String[])StreamSupport.stream(otherMap.keySet().spliterator(), false).toArray(String[]::new);
            Arrays.sort(thatKeys, String::compareTo);
            for (i = 0; i < size; ++i) {
                compare = thisKeys[i].compareTo(thatKeys[i]);
                if (compare == 0) continue;
                return compare;
            }
            for (i = 0; i < size; ++i) {
                String key = thisKeys[i];
                compare = comparator.compare(this.get(key), otherMap.get(key));
                if (compare == 0) continue;
                return compare;
            }
        }
        return compare;
    }

    @Override
    public Comparison unsafeTernaryCompareTo(VirtualValue other, TernaryComparator<AnyValue> comparator) {
        MapValue otherMap = (MapValue)other;
        int size = this.size();
        int compare = Integer.compare(size, otherMap.size());
        if (compare == 0) {
            int i;
            String[] thisKeys = (String[])StreamSupport.stream(this.keySet().spliterator(), false).toArray(String[]::new);
            Arrays.sort(thisKeys, String::compareTo);
            String[] thatKeys = (String[])StreamSupport.stream(otherMap.keySet().spliterator(), false).toArray(String[]::new);
            Arrays.sort(thatKeys, String::compareTo);
            for (i = 0; i < size; ++i) {
                compare = thisKeys[i].compareTo(thatKeys[i]);
                if (compare == 0) continue;
                return Comparison.from(compare);
            }
            for (i = 0; i < size; ++i) {
                String key = thisKeys[i];
                Comparison comparison = comparator.ternaryCompare(this.get(key), otherMap.get(key));
                if (comparison == Comparison.EQUAL) continue;
                return comparison;
            }
        }
        return Comparison.from(compare);
    }

    @Override
    public Equality ternaryEquals(AnyValue other) {
        assert (other != null) : "null values are not supported, use NoValue.NO_VALUE instead";
        if (other == Values.NO_VALUE) {
            return Equality.UNDEFINED;
        }
        if (!(other instanceof MapValue)) {
            return Equality.FALSE;
        }
        MapValue otherMap = (MapValue)other;
        int size = this.size();
        if (size != otherMap.size()) {
            return Equality.FALSE;
        }
        String[] thisKeys = (String[])StreamSupport.stream(this.keySet().spliterator(), false).toArray(String[]::new);
        Arrays.sort(thisKeys, String::compareTo);
        String[] thatKeys = (String[])StreamSupport.stream(otherMap.keySet().spliterator(), false).toArray(String[]::new);
        Arrays.sort(thatKeys, String::compareTo);
        for (int i = 0; i < size; ++i) {
            if (thisKeys[i].compareTo(thatKeys[i]) == 0) continue;
            return Equality.FALSE;
        }
        Equality equalityResult = Equality.TRUE;
        for (int i = 0; i < size; ++i) {
            AnyValue otherValue;
            String key = thisKeys[i];
            AnyValue thisValue = this.get(key);
            Equality equality = thisValue.ternaryEquals(otherValue = otherMap.get(key));
            if (equality == Equality.UNDEFINED) {
                equalityResult = Equality.UNDEFINED;
                continue;
            }
            if (equality != Equality.FALSE) continue;
            return Equality.FALSE;
        }
        return equalityResult;
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapMap(this);
    }

    public abstract <E extends Exception> void foreach(ThrowingBiConsumer<String, AnyValue, E> var1) throws E;

    public abstract boolean containsKey(String var1);

    public abstract AnyValue get(String var1);

    public abstract int size();

    public MapValue filter(BiFunction<String, AnyValue, Boolean> filterFunction) {
        return new FilteringMapValue(this, filterFunction);
    }

    public MapValue updatedWith(String key, AnyValue value) {
        if (!this.containsKey(key)) {
            return new UpdatedMapValue(this, key, value);
        }
        AnyValue current = this.get(key);
        if (current.equals(value)) {
            return this;
        }
        return new MappedMapValue(this, (k, v) -> {
            if (k.equals(key)) {
                return value;
            }
            return v;
        });
    }

    public MapValue updatedWith(MapValue other) {
        return new CombinedMapValue(this, other);
    }

    @Override
    public String getTypeName() {
        return "Map";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getTypeName()).append('{');
        String[] sep = new String[]{""};
        this.foreach((key, value) -> {
            sb.append(sep[0]);
            sb.append((String)key);
            sb.append(" -> ");
            sb.append(value);
            sep[0] = ", ";
        });
        sb.append('}');
        return sb.toString();
    }

    private static final class CombinedMapValue
    extends MapValue {
        private final MapValue map1;
        private final MapValue map2;

        CombinedMapValue(MapValue map1, MapValue map2) {
            this.map1 = map1;
            this.map2 = map2;
        }

        @Override
        public Iterable<String> keySet() {
            return () -> new PrefetchingIterator<String>(){
                private boolean iteratingMap2;
                private Iterator iterator;
                private Set seen;
                {
                    this.iterator = map1.keySet().iterator();
                    this.seen = new HashSet();
                }

                protected String fetchNextOrNull() {
                    while (!this.iteratingMap2 || this.iterator.hasNext()) {
                        if (!this.iterator.hasNext()) {
                            this.iterator = map2.keySet().iterator();
                            this.iteratingMap2 = true;
                        }
                        while (this.iterator.hasNext()) {
                            String key = (String)this.iterator.next();
                            if (!this.seen.add(key)) continue;
                            return key;
                        }
                    }
                    return null;
                }
            };
        }

        @Override
        public <E extends Exception> void foreach(ThrowingBiConsumer<String, AnyValue, E> f) throws E {
            HashSet seen = new HashSet();
            ThrowingBiConsumer consume = (key, value) -> {
                if (seen.add(key)) {
                    f.accept(key, value);
                }
            };
            this.map2.foreach(consume);
            this.map1.foreach(consume);
        }

        @Override
        public boolean containsKey(String key) {
            if (this.map1.containsKey(key)) {
                return true;
            }
            return this.map2.containsKey(key);
        }

        @Override
        public AnyValue get(String key) {
            AnyValue value2 = this.map2.get(key);
            if (value2 != Values.NO_VALUE) {
                return value2;
            }
            return this.map1.get(key);
        }

        @Override
        public int size() {
            int[] size = new int[]{0};
            HashSet seen = new HashSet();
            ThrowingBiConsumer consume = (key, value) -> {
                if (seen.add(key)) {
                    size[0] = size[0] + 1;
                }
            };
            this.map1.foreach(consume);
            this.map2.foreach(consume);
            return size[0];
        }

        public long estimatedHeapUsage() {
            return COMBINED_MAP_VALUE_SHALLOW_SIZE + this.map1.estimatedHeapUsage() + this.map2.estimatedHeapUsage();
        }
    }

    private static final class UpdatedMapValue
    extends MapValue {
        private final MapValue map;
        private final String updatedKey;
        private final AnyValue updatedValue;

        UpdatedMapValue(MapValue map, String updatedKey, AnyValue updatedValue) {
            assert (!map.containsKey(updatedKey));
            this.map = map;
            this.updatedKey = updatedKey;
            this.updatedValue = updatedValue;
        }

        @Override
        public ListValue keys() {
            return VirtualValues.concat(this.map.keys(), VirtualValues.fromArray(Values.stringArray(this.updatedKey)));
        }

        @Override
        public Iterable<String> keySet() {
            return () -> new Iterator<String>(){
                private boolean hasNext;
                private Iterator internal;
                {
                    this.internal = map.keySet().iterator();
                    this.hasNext = true;
                }

                @Override
                public boolean hasNext() {
                    if (this.internal.hasNext()) {
                        return true;
                    }
                    return this.hasNext;
                }

                @Override
                public String next() {
                    if (this.internal.hasNext()) {
                        return (String)this.internal.next();
                    }
                    if (this.hasNext) {
                        this.hasNext = false;
                        return updatedKey;
                    }
                    throw new NoSuchElementException();
                }
            };
        }

        @Override
        public <E extends Exception> void foreach(ThrowingBiConsumer<String, AnyValue, E> f) throws E {
            this.map.foreach(f);
            f.accept((Object)this.updatedKey, (Object)this.updatedValue);
        }

        @Override
        public boolean containsKey(String key) {
            if (this.updatedKey.equals(key)) {
                return true;
            }
            return this.map.containsKey(key);
        }

        @Override
        public AnyValue get(String key) {
            if (this.updatedKey.equals(key)) {
                return this.updatedValue;
            }
            return this.map.get(key);
        }

        @Override
        public int size() {
            return this.map.size() + 1;
        }

        public long estimatedHeapUsage() {
            return UPDATED_MAP_VALUE_SHALLOW_SIZE + this.map.estimatedHeapUsage() + HeapEstimator.sizeOf((String)this.updatedKey) + this.updatedValue.estimatedHeapUsage();
        }
    }

    private static final class MappedMapValue
    extends MapValue {
        private final MapValue map;
        private final BiFunction<String, AnyValue, AnyValue> mapFunction;

        MappedMapValue(MapValue map, BiFunction<String, AnyValue, AnyValue> mapFunction) {
            this.map = map;
            this.mapFunction = mapFunction;
        }

        @Override
        public ListValue keys() {
            return this.map.keys();
        }

        @Override
        public Iterable<String> keySet() {
            return this.map.keySet();
        }

        @Override
        public <E extends Exception> void foreach(ThrowingBiConsumer<String, AnyValue, E> f) throws E {
            this.map.foreach((s, anyValue) -> f.accept(s, (Object)this.mapFunction.apply((String)s, (AnyValue)anyValue)));
        }

        @Override
        public boolean containsKey(String key) {
            return this.map.containsKey(key);
        }

        @Override
        public AnyValue get(String key) {
            return this.mapFunction.apply(key, this.map.get(key));
        }

        @Override
        public int size() {
            return this.map.size();
        }

        public long estimatedHeapUsage() {
            return MAPPED_MAP_VALUE_SHALLOW_SIZE + this.map.estimatedHeapUsage();
        }
    }

    private static final class FilteringMapValue
    extends MapValue {
        private final MapValue map;
        private final BiFunction<String, AnyValue, Boolean> filter;
        private int size = -1;

        FilteringMapValue(MapValue map, BiFunction<String, AnyValue, Boolean> filter) {
            this.map = map;
            this.filter = filter;
        }

        @Override
        public Iterable<String> keySet() {
            ArrayList<String> keys = this.size >= 0 ? new ArrayList<String>(this.size) : new ArrayList();
            this.foreach((key, value) -> {
                if (this.filter.apply((String)key, (AnyValue)value).booleanValue()) {
                    keys.add((String)key);
                }
            });
            return keys;
        }

        @Override
        public <E extends Exception> void foreach(ThrowingBiConsumer<String, AnyValue, E> f) throws E {
            this.map.foreach((s, anyValue) -> {
                if (this.filter.apply((String)s, (AnyValue)anyValue).booleanValue()) {
                    f.accept(s, anyValue);
                }
            });
        }

        @Override
        public boolean containsKey(String key) {
            AnyValue value = this.map.get(key);
            if (value == Values.NO_VALUE) {
                return false;
            }
            return this.filter.apply(key, value);
        }

        @Override
        public AnyValue get(String key) {
            AnyValue value = this.map.get(key);
            if (value == Values.NO_VALUE) {
                return Values.NO_VALUE;
            }
            if (this.filter.apply(key, value).booleanValue()) {
                return value;
            }
            return Values.NO_VALUE;
        }

        @Override
        public int size() {
            if (this.size < 0) {
                this.size = 0;
                this.foreach((k, v) -> {
                    if (this.filter.apply((String)k, (AnyValue)v).booleanValue()) {
                        ++this.size;
                    }
                });
            }
            return this.size;
        }

        public long estimatedHeapUsage() {
            return FILTERING_MAP_VALUE_SHALLOW_SIZE + this.map.estimatedHeapUsage();
        }
    }

    static final class MapWrappingMapValue
    extends MapValue {
        private final Map<String, AnyValue> map;
        private final long wrappedHeapSize;

        MapWrappingMapValue(Map<String, AnyValue> map, long payloadSize) {
            this.map = map;
            this.wrappedHeapSize = HeapEstimator.sizeOfHashMap(map) + payloadSize;
        }

        @Override
        public Iterable<String> keySet() {
            return this.map.keySet();
        }

        @Override
        public <E extends Exception> void foreach(ThrowingBiConsumer<String, AnyValue, E> f) throws E {
            for (Map.Entry<String, AnyValue> entry : this.map.entrySet()) {
                f.accept((Object)entry.getKey(), (Object)entry.getValue());
            }
        }

        @Override
        public boolean containsKey(String key) {
            return this.map.containsKey(key);
        }

        @Override
        public AnyValue get(String key) {
            return this.map.getOrDefault(key, Values.NO_VALUE);
        }

        @Override
        public int size() {
            return this.map.size();
        }

        public long estimatedHeapUsage() {
            return MAP_WRAPPING_MAP_VALUE_SHALLOW_SIZE + this.wrappedHeapSize;
        }
    }
}

