/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values;

import java.util.Map;
import org.neo4j.exceptions.InvalidArgumentException;
import org.neo4j.values.AnyValue;
import org.neo4j.values.virtual.MapValue;

public interface StructureBuilder<Input, Result> {
    public StructureBuilder<Input, Result> add(String var1, Input var2);

    public Result build();

    public static <T> T build(StructureBuilder<AnyValue, T> builder, MapValue map) {
        if (map.size() == 0) {
            throw new InvalidArgumentException("At least one temporal unit must be specified.");
        }
        map.foreach(builder::add);
        return builder.build();
    }

    public static <T> T build(StructureBuilder<AnyValue, T> builder, Iterable<Map.Entry<String, AnyValue>> entries) {
        for (Map.Entry<String, AnyValue> entry : entries) {
            builder.add(entry.getKey(), entry.getValue());
        }
        return builder.build();
    }
}

