/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.virtual;

import java.util.Comparator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.Comparison;
import org.neo4j.values.TernaryComparator;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.VirtualValue;
import org.neo4j.values.virtual.VirtualValueGroup;

public abstract class VirtualRelationshipValue
extends VirtualValue {
    public abstract long id();

    @Override
    public int unsafeCompareTo(VirtualValue other, Comparator<AnyValue> comparator) {
        VirtualRelationshipValue otherNode = (VirtualRelationshipValue)other;
        return Long.compare(this.id(), otherNode.id());
    }

    @Override
    public Comparison unsafeTernaryCompareTo(VirtualValue other, TernaryComparator<AnyValue> comparator) {
        return Comparison.from(this.unsafeCompareTo(other, comparator));
    }

    @Override
    public int computeHash() {
        return Long.hashCode(this.id());
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapRelationship(this);
    }

    @Override
    public boolean equals(VirtualValue other) {
        if (!(other instanceof VirtualRelationshipValue)) {
            return false;
        }
        VirtualRelationshipValue that = (VirtualRelationshipValue)other;
        return this.id() == that.id();
    }

    @Override
    public VirtualValueGroup valueGroup() {
        return VirtualValueGroup.EDGE;
    }
}

