/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.virtual;

import java.util.Comparator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.VirtualValue;
import org.neo4j.values.virtual.VirtualValueGroup;

abstract class VirtualNodeValue
extends VirtualValue {
    VirtualNodeValue() {
    }

    public abstract long id();

    @Override
    public int compareTo(VirtualValue other, Comparator<AnyValue> comparator) {
        if (!(other instanceof VirtualNodeValue)) {
            throw new IllegalArgumentException("Cannot compare different virtual values");
        }
        VirtualNodeValue otherNode = (VirtualNodeValue)other;
        return Long.compare(this.id(), otherNode.id());
    }

    @Override
    public int hash() {
        return Long.hashCode(this.id());
    }

    @Override
    public boolean equals(VirtualValue other) {
        if (!(other instanceof VirtualNodeValue)) {
            return false;
        }
        VirtualNodeValue that = (VirtualNodeValue)other;
        return this.id() == that.id();
    }

    @Override
    public VirtualValueGroup valueGroup() {
        return VirtualValueGroup.NODE;
    }
}

