/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.virtual;

import java.util.Arrays;
import java.util.Comparator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.VirtualValue;
import org.neo4j.values.virtual.EdgeValue;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.VirtualValueGroup;

final class PathValue
extends VirtualValue {
    private final NodeValue[] nodes;
    private final EdgeValue[] edges;

    PathValue(NodeValue[] nodes, EdgeValue[] edges) {
        assert (nodes != null);
        assert (edges != null);
        assert (nodes.length == edges.length + 1);
        this.nodes = nodes;
        this.edges = edges;
    }

    @Override
    public boolean equals(VirtualValue other) {
        if (other == null || other.getClass() != PathValue.class) {
            return false;
        }
        PathValue that = (PathValue)other;
        return this.size() == that.size() && Arrays.equals(this.nodes, that.nodes) && Arrays.equals(this.edges, that.edges);
    }

    @Override
    public int hash() {
        int result = this.nodes[0].hashCode();
        for (int i = 1; i < this.nodes.length; ++i) {
            result += 31 * (result + this.edges[i - 1].hashCode());
            result += 31 * (result + this.nodes[i].hashCode());
        }
        return result;
    }

    @Override
    public <E extends Exception> void writeTo(AnyValueWriter<E> writer) throws E {
        writer.writePath(this.nodes, this.edges);
    }

    @Override
    public VirtualValueGroup valueGroup() {
        return VirtualValueGroup.PATH;
    }

    @Override
    public int compareTo(VirtualValue other, Comparator<AnyValue> comparator) {
        if (other == null || other.getClass() != PathValue.class) {
            throw new IllegalArgumentException("Cannot compare different virtual values");
        }
        PathValue otherPath = (PathValue)other;
        int x = Integer.compare(this.edges.length, otherPath.edges.length);
        if (x == 0) {
            for (int i = 0; i < this.edges.length; ++i) {
                x = this.edges[i].compareTo((VirtualValue)otherPath.edges[i], (Comparator)comparator);
                if (x == 0) continue;
                return x;
            }
            x = this.nodes[0].compareTo((VirtualValue)otherPath.nodes[0], (Comparator)comparator);
        }
        return x;
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder("Path{");
        for (i = 0; i < this.edges.length; ++i) {
            sb.append(this.nodes[i]);
            sb.append(this.edges[i]);
        }
        sb.append(this.nodes[i]);
        sb.append('}');
        return sb.toString();
    }

    public int size() {
        return this.edges.length;
    }
}

