/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.virtual;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.neo4j.values.AnyValue;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.VirtualValue;
import org.neo4j.values.virtual.VirtualValueGroup;

public final class MapValue
extends VirtualValue {
    private final Map<String, AnyValue> map;

    MapValue(Map<String, AnyValue> map) {
        this.map = map;
    }

    @Override
    public boolean equals(VirtualValue other) {
        if (other == null || other.getClass() != MapValue.class) {
            return false;
        }
        MapValue that = (MapValue)other;
        return this.map.equals(that.map);
    }

    @Override
    public int hash() {
        return this.map.hashCode();
    }

    @Override
    public <E extends Exception> void writeTo(AnyValueWriter<E> writer) throws E {
        writer.beginMap(this.map.size());
        for (Map.Entry<String, AnyValue> entry : this.map.entrySet()) {
            writer.writeString(entry.getKey());
            entry.getValue().writeTo(writer);
        }
        writer.endMap();
    }

    @Override
    public VirtualValueGroup valueGroup() {
        return VirtualValueGroup.MAP;
    }

    @Override
    public int compareTo(VirtualValue other, Comparator<AnyValue> comparator) {
        if (other == null || other.getClass() != MapValue.class) {
            throw new IllegalArgumentException("Cannot compare different virtual values");
        }
        Map<String, AnyValue> otherMap = ((MapValue)other).map;
        int size = this.map.size();
        int compare = Integer.compare(this.size(), otherMap.size());
        if (compare == 0) {
            int i;
            String[] thisKeys = this.map.keySet().toArray(new String[size]);
            Arrays.sort(thisKeys, String::compareTo);
            String[] thatKeys = otherMap.keySet().toArray(new String[size]);
            Arrays.sort(thatKeys, String::compareTo);
            for (i = 0; i < size; ++i) {
                compare = thisKeys[i].compareTo(thatKeys[i]);
                if (compare == 0) continue;
                return compare;
            }
            for (i = 0; i < size; ++i) {
                String key = thisKeys[i];
                compare = comparator.compare(this.map.get(key), otherMap.get(key));
                if (compare == 0) continue;
                return compare;
            }
        }
        return compare;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Map{");
        String sep = "";
        for (Map.Entry<String, AnyValue> entry : this.map.entrySet()) {
            sb.append(sep);
            sb.append(entry.getKey());
            sb.append(" -> ");
            sb.append(entry.getValue());
            sep = ", ";
        }
        sb.append('}');
        return sb.toString();
    }

    public int size() {
        return this.map.size();
    }
}

