/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.virtual;

import java.util.Arrays;
import java.util.Comparator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.VirtualValue;
import org.neo4j.values.virtual.ArrayHelpers;
import org.neo4j.values.virtual.VirtualValueGroup;

final class ListValue
extends VirtualValue {
    private final AnyValue[] values;

    ListValue(AnyValue[] values) {
        assert (values != null);
        assert (!ArrayHelpers.hasNullOrNoValue(values));
        this.values = values;
    }

    @Override
    public boolean equals(VirtualValue other) {
        if (other == null || other.getClass() != ListValue.class) {
            return false;
        }
        ListValue that = (ListValue)other;
        return this.size() == that.size() && Arrays.equals(this.values, that.values);
    }

    @Override
    public int hash() {
        return Arrays.hashCode(this.values);
    }

    @Override
    public <E extends Exception> void writeTo(AnyValueWriter<E> writer) throws E {
        writer.beginList(this.values.length);
        for (AnyValue value : this.values) {
            value.writeTo(writer);
        }
        writer.endList();
    }

    @Override
    public VirtualValueGroup valueGroup() {
        return VirtualValueGroup.LIST;
    }

    @Override
    public int compareTo(VirtualValue other, Comparator<AnyValue> comparator) {
        if (other == null || other.getClass() != ListValue.class) {
            throw new IllegalArgumentException("Cannot compare different virtual values");
        }
        ListValue otherList = (ListValue)other;
        int x = Integer.compare(this.size(), otherList.size());
        if (x == 0) {
            for (int i = 0; i < this.size(); ++i) {
                x = comparator.compare(this.values[i], otherList.values[i]);
                if (x == 0) continue;
                return x;
            }
        }
        return x;
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder("List{");
        for (i = 0; i < this.values.length - 1; ++i) {
            sb.append(this.values[i]);
            sb.append(", ");
        }
        if (this.values.length > 0) {
            sb.append(this.values[i]);
        }
        sb.append('}');
        return sb.toString();
    }

    public int size() {
        return this.values.length;
    }

    public AnyValue value(int offset) {
        return this.values[offset];
    }
}

