/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.virtual;

import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualEdgeValue;

public class EdgeValue
extends VirtualEdgeValue {
    private final long id;
    private final long startNodeId;
    private final long endNodeId;
    private final TextValue type;
    private final MapValue properties;

    EdgeValue(long id, long startNodeId, long endNodeId, TextValue type, MapValue properties) {
        assert (properties != null);
        this.startNodeId = startNodeId;
        this.endNodeId = endNodeId;
        this.id = id;
        this.type = type;
        this.properties = properties;
    }

    @Override
    public <E extends Exception> void writeTo(AnyValueWriter<E> writer) throws E {
        writer.writeEdge(this.id, this.startNodeId, this.endNodeId, this.type, this.properties);
    }

    public String toString() {
        return String.format("-[%d]-", this.id);
    }

    public long startNode() {
        return this.startNodeId;
    }

    public long endNode() {
        return this.endNodeId;
    }

    @Override
    public long id() {
        return this.id;
    }
}

