/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.TextValues;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueWriter;

final class CharValue
extends TextValue {
    final char value;

    CharValue(char value) {
        this.value = value;
    }

    @Override
    public boolean equals(Object other) {
        return other != null && other instanceof Value && this.equals((Value)other);
    }

    @Override
    public boolean equals(Value other) {
        return other.equals(this.value);
    }

    @Override
    public boolean equals(boolean x) {
        return false;
    }

    @Override
    public boolean equals(char x) {
        return this.value == x;
    }

    @Override
    public boolean equals(String x) {
        return x.length() == 1 && x.charAt(0) == this.value;
    }

    @Override
    public int hashCode() {
        return this.value;
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        writer.writeString(this.value);
    }

    @Override
    public Object asObjectCopy() {
        return Character.valueOf(this.value);
    }

    @Override
    public String prettyPrint() {
        return String.format("'%s'", Character.valueOf(this.value));
    }

    @Override
    public String stringValue() {
        return Character.toString(this.value);
    }

    @Override
    public int compareTo(TextValue other) {
        return TextValues.compareCharToString(this.value, other.stringValue());
    }

    public String toString() {
        return String.format("Char('%s')", Character.valueOf(this.value));
    }
}

