/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.virtual;

import java.util.List;
import org.neo4j.function.ThrowingBiConsumer;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;

public final class SingletonMapValue
extends MapValue {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(SingletonMapValue.class);
    private final String key;
    private final AnyValue value;

    public SingletonMapValue(String key, AnyValue value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public Iterable<String> keySet() {
        return List.of(this.key);
    }

    @Override
    public <E extends Exception> void foreach(ThrowingBiConsumer<String, AnyValue, E> f) throws E {
        f.accept((Object)this.key, (Object)this.value);
    }

    @Override
    public boolean containsKey(String key) {
        return this.key.equals(key);
    }

    @Override
    public AnyValue get(String key) {
        return this.key.equals(key) ? this.value : Values.NO_VALUE;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public long estimatedHeapUsage() {
        return SHALLOW_SIZE + HeapEstimator.sizeOf((String)this.key) + this.value.estimatedHeapUsage();
    }
}

