/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import org.neo4j.hashing.HashFunction;
import org.neo4j.values.Comparison;
import org.neo4j.values.VectorCandidate;
import org.neo4j.values.storable.FloatingPointVector;
import org.neo4j.values.storable.HashMemoizingScalarValue;
import org.neo4j.values.storable.IntegralVector;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Vector;
import org.neo4j.values.utils.PrettyPrinter;

public abstract sealed class VectorValue
extends HashMemoizingScalarValue
implements Vector,
VectorCandidate
permits IntegralVector, FloatingPointVector {
    public static final int MIN_VECTOR_DIMENSIONS = 1;
    public static final int MAX_VECTOR_DIMENSIONS = 4096;

    @Override
    public Vector asObjectCopy() {
        return this;
    }

    @Override
    public String prettyPrint() {
        PrettyPrinter pp = new PrettyPrinter();
        this.writeTo(pp);
        return pp.value();
    }

    @Override
    public Comparison unsafeTernaryCompareTo(Value otherValue) {
        if (this.equals(otherValue)) {
            return Comparison.EQUAL;
        }
        return Comparison.UNDEFINED;
    }

    @Override
    public boolean isIncomparableType() {
        return true;
    }

    protected abstract long longBits(int var1);

    public abstract String nestedTypeName();

    @Override
    public long updateHash(HashFunction hashFunction, long hash) {
        int len = this.dimensions();
        hash = hashFunction.update(hash, (long)len);
        for (int i = 0; i < len; ++i) {
            hash = hashFunction.update(hash, this.longBits(i));
        }
        return hash;
    }

    public static void ensureValidDimensions(int dimensions) {
        if (dimensions < 1 || dimensions > 4096) {
            throw new IllegalArgumentException("Expected vector dimension in [%d, %d], but was %d".formatted(1, 4096, dimensions));
        }
    }
}

