/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.util.Arrays;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.IntegralVector;
import org.neo4j.values.storable.NumberValues;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueRepresentation;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Vector;

public final class Int16Vector
extends IntegralVector {
    public static final String NESTED_TYPE_NAME = "INTEGER16";
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(Int16Vector.class);
    private final short[] coordinates;

    Int16Vector(short ... coordinates) {
        this.coordinates = coordinates;
    }

    @Override
    public float floatValue(int index) {
        return this.coordinates[index];
    }

    @Override
    public double doubleValue(int index) {
        return this.coordinates[index];
    }

    @Override
    public int dimensions() {
        return this.coordinates.length;
    }

    @Override
    public String getTypeName() {
        return "Int16Vector";
    }

    @Override
    public ValueRepresentation valueRepresentation() {
        return ValueRepresentation.INT16_VECTOR;
    }

    @Override
    public Vector.CoordinateType coordinateType() {
        return Vector.CoordinateType.INTEGER16;
    }

    @Override
    public boolean equals(Value other) {
        if (other instanceof Int16Vector) {
            Int16Vector v = (Int16Vector)other;
            return Arrays.equals(this.coordinates, v.coordinates);
        }
        return false;
    }

    @Override
    protected int unsafeCompareTo(Value other) {
        Int16Vector that = (Int16Vector)other;
        int comparison = Integer.compare(this.dimensions(), that.dimensions());
        if (comparison != 0) {
            return comparison;
        }
        return Arrays.compare(this.coordinates, that.coordinates);
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        writer.writeInt16Vector(this.coordinates);
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapInt16Vector(this);
    }

    @Override
    protected long longBits(int i) {
        return this.coordinates[i];
    }

    @Override
    protected int computeHashToMemoize() {
        return NumberValues.hash(this.coordinates);
    }

    public long estimatedHeapUsage() {
        return SHALLOW_SIZE + HeapEstimator.sizeOf((short[])this.coordinates);
    }

    public String toString() {
        return String.format("%s%s", this.getTypeName(), Arrays.toString(this.coordinates));
    }
}

