/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.token.api;

import java.util.function.IntFunction;
import org.neo4j.common.TokenNameLookup;

public class TokenIdPrettyPrinter {
    private TokenIdPrettyPrinter() {
    }

    public static String label(int id) {
        return id == -1 ? "" : ":label=" + id;
    }

    public static String propertyKey(int id) {
        return id == -1 ? "" : ":propertyKey=" + id;
    }

    public static String relationshipType(int id) {
        return id == -1 ? "" : "[:type=" + id + "]";
    }

    public static String niceProperties(TokenNameLookup tokenNameLookup, int[] propertyIds) {
        return TokenIdPrettyPrinter.niceProperties(tokenNameLookup, propertyIds, "");
    }

    public static String niceProperties(TokenNameLookup lookup, int[] propertyIds, String prefix) {
        StringBuilder out = new StringBuilder();
        out.append('(');
        TokenIdPrettyPrinter.format(out, prefix, ", ", arg_0 -> ((TokenNameLookup)lookup).propertyKeyGetName(arg_0), propertyIds);
        out.append(')');
        return out.toString();
    }

    public static String niceEntityLabels(IntFunction<String> lookup, int[] labelIds) {
        StringBuilder out = new StringBuilder();
        out.append(':');
        TokenIdPrettyPrinter.format(out, "", ",", lookup, labelIds);
        return out.toString();
    }

    public static void format(StringBuilder out, String prefix, String separator, IntFunction<String> lookup, int[] ids) {
        for (int id : ids) {
            String name = lookup.apply(id);
            out.append(prefix);
            if (name.contains(":")) {
                out.append('`').append(name).append('`');
            } else {
                out.append(name);
            }
            out.append(separator);
        }
        if (ids.length > 0) {
            out.setLength(out.length() - separator.length());
        }
    }
}

