/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.tinkerpop.api.impl;

import java.util.Set;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.tinkerpop.api.Neo4jDirection;
import org.neo4j.tinkerpop.api.Neo4jNode;
import org.neo4j.tinkerpop.api.Neo4jRelationship;
import org.neo4j.tinkerpop.api.impl.Neo4jEntityImpl;
import org.neo4j.tinkerpop.api.impl.Neo4jRelationshipImpl;
import org.neo4j.tinkerpop.api.impl.Util;

public class Neo4jNodeImpl
extends Neo4jEntityImpl<Node>
implements Neo4jNode {
    public Neo4jNodeImpl(Node node) {
        super(node);
    }

    public Set<String> labels() {
        return Util.toLabels(((Node)this.entity).getLabels());
    }

    public boolean hasLabel(String label) {
        return ((Node)this.entity).hasLabel(Label.label((String)label));
    }

    public void addLabel(String label) {
        ((Node)this.entity).addLabel(Label.label((String)label));
    }

    public void removeLabel(String label) {
        ((Node)this.entity).removeLabel(Label.label((String)label));
    }

    public int degree(Neo4jDirection direction, String type) {
        return type == null ? (direction != null ? ((Node)this.entity).getDegree(Direction.valueOf((String)direction.name())) : ((Node)this.entity).getDegree()) : (direction != null ? ((Node)this.entity).getDegree(RelationshipType.withName((String)type), Direction.valueOf((String)direction.name())) : ((Node)this.entity).getDegree(RelationshipType.withName((String)type)));
    }

    public Iterable<Neo4jRelationship> relationships(Neo4jDirection direction, String ... types) {
        Iterable relationships = types.length == 0 ? (direction != null ? ((Node)this.entity).getRelationships(Direction.valueOf((String)direction.name())) : ((Node)this.entity).getRelationships()) : (direction != null ? ((Node)this.entity).getRelationships(Direction.valueOf((String)direction.name()), Util.types(types)) : ((Node)this.entity).getRelationships(Util.types(types)));
        return new IterableWrapper<Neo4jRelationship, Relationship>(relationships){

            protected Neo4jRelationship underlyingObjectToObject(Relationship relationship) {
                return new Neo4jRelationshipImpl(relationship);
            }
        };
    }

    public Neo4jRelationship connectTo(Neo4jNode node, String type) {
        return Util.wrap(((Node)this.entity).createRelationshipTo((Node)((Neo4jNodeImpl)node).entity, RelationshipType.withName((String)type)));
    }
}

