/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.tinkerpop.api.impl;

import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.tinkerpop.api.Neo4jEntity;

public class Neo4jEntityImpl<T extends PropertyContainer>
implements Neo4jEntity {
    protected final T entity;

    public Neo4jEntityImpl(T entity) {
        this.entity = entity;
    }

    public long getId() {
        return this.entity instanceof Node ? ((Node)this.entity).getId() : ((Relationship)this.entity).getId();
    }

    public Iterable<String> getKeys() {
        return this.entity.getPropertyKeys();
    }

    public Object getProperty(String name) {
        return this.entity.getProperty(name);
    }

    public Object getProperty(String name, Object defaultValue) {
        return this.entity.getProperty(name, defaultValue);
    }

    public void setProperty(String name, Object value) {
        this.entity.setProperty(name, value);
    }

    public Object removeProperty(String name) {
        return this.entity.removeProperty(name);
    }

    public boolean hasProperty(String name) {
        return this.entity.hasProperty(name);
    }

    public void delete() {
        if (this.entity instanceof Node) {
            ((Node)this.entity).delete();
        } else {
            ((Relationship)this.entity).delete();
        }
    }

    public String toString() {
        return this.entity.toString();
    }

    public boolean equals(Object obj) {
        return this.getClass().isInstance(obj) && ((Neo4jEntity)obj).getId() == this.getId();
    }

    public int hashCode() {
        return (int)this.getId();
    }

    public T getEntity() {
        return this.entity;
    }
}

