/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.counts;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.neo4j.index.internal.gbptree.Header;
import org.neo4j.io.pagecache.PageCursor;

class CountsHeader {
    CountsHeader() {
    }

    static Reader reader() {
        return new Reader();
    }

    static Writer writer(long highestGapFreeTxId) {
        return new Writer(highestGapFreeTxId);
    }

    static class Reader
    implements Header.Reader {
        private boolean wasRead;
        private long highestGapFreeTxId;

        Reader() {
        }

        public void read(ByteBuffer headerBytes) {
            this.wasRead = true;
            this.highestGapFreeTxId = headerBytes.getLong();
        }

        boolean wasRead() {
            return this.wasRead;
        }

        long highestGapFreeTxId() {
            return this.highestGapFreeTxId;
        }
    }

    static class Writer
    implements Consumer<PageCursor> {
        private final long highestGapFreeTxId;

        Writer(long highestGapFreeTxId) {
            this.highestGapFreeTxId = highestGapFreeTxId;
        }

        @Override
        public void accept(PageCursor cursor) {
            cursor.putLong(this.highestGapFreeTxId);
        }
    }
}

