/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.neo4j.exceptions.KernelException;
import org.neo4j.exceptions.UnderlyingStorageException;
import org.neo4j.internal.helpers.collection.NestingIterator;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.IndexUpdateListener;
import org.neo4j.storageengine.api.IndexUpdatesListener;
import org.neo4j.util.concurrent.AsyncApply;
import org.neo4j.util.concurrent.Work;
import org.neo4j.util.concurrent.WorkSync;

public class IndexUpdatesWorkSync {
    private final WorkSync<IndexUpdateListener, IndexUpdatesWork> workSync;
    private final IndexUpdateListener listener;
    private final boolean parallelApply;

    public IndexUpdatesWorkSync(IndexUpdateListener listener, boolean parallelApply) {
        this.listener = listener;
        this.parallelApply = parallelApply;
        this.workSync = parallelApply ? null : new WorkSync((Object)listener);
    }

    public Batch newBatch(CursorContext cursorContext) {
        return new Batch(cursorContext);
    }

    private static Iterable<IndexEntryUpdate<IndexDescriptor>> combinedUpdates(List<Iterable<IndexEntryUpdate<IndexDescriptor>>> updates) {
        return () -> new NestingIterator<IndexEntryUpdate<IndexDescriptor>, Iterable<IndexEntryUpdate<IndexDescriptor>>>(updates.iterator()){

            protected Iterator<IndexEntryUpdate<IndexDescriptor>> createNestedIterator(Iterable<IndexEntryUpdate<IndexDescriptor>> item) {
                return item.iterator();
            }
        };
    }

    public class Batch
    implements IndexUpdatesListener {
        private final List<Iterable<IndexEntryUpdate<IndexDescriptor>>> updates = new ArrayList<Iterable<IndexEntryUpdate<IndexDescriptor>>>();
        private final CursorContext cursorContext;
        private List<IndexEntryUpdate<IndexDescriptor>> singleUpdates;
        private AsyncApply apply;

        public Batch(CursorContext cursorContext) {
            this.cursorContext = cursorContext;
        }

        public void indexUpdates(Iterable<IndexEntryUpdate<IndexDescriptor>> indexUpdates) {
            this.updates.add(indexUpdates);
        }

        public void indexUpdate(IndexEntryUpdate<IndexDescriptor> indexUpdate) {
            if (this.singleUpdates == null) {
                this.singleUpdates = new ArrayList<IndexEntryUpdate<IndexDescriptor>>();
            }
            this.singleUpdates.add(indexUpdate);
        }

        private void addSingleUpdates() {
            if (this.singleUpdates != null) {
                this.updates.add(this.singleUpdates);
            }
        }

        public void close() throws IOException {
            try {
                if (this.apply == null) {
                    this.apply();
                }
                this.apply.await();
            }
            catch (ExecutionException e) {
                throw this.wrapExecutionException(e);
            }
        }

        private IOException wrapExecutionException(ExecutionException e) {
            IOException ioe;
            Throwable throwable = e.getCause();
            return throwable instanceof IOException ? (ioe = (IOException)throwable) : new IOException(e.getCause());
        }

        private void apply() throws IOException, ExecutionException {
            this.addSingleUpdates();
            if (!this.updates.isEmpty()) {
                if (IndexUpdatesWorkSync.this.parallelApply) {
                    try {
                        IndexUpdatesWorkSync.this.listener.applyUpdates(IndexUpdatesWorkSync.combinedUpdates(this.updates), this.cursorContext, true);
                    }
                    catch (KernelException e) {
                        throw new IOException(e);
                    }
                } else {
                    IndexUpdatesWorkSync.this.workSync.apply((Work)new IndexUpdatesWork(IndexUpdatesWorkSync.combinedUpdates(this.updates), this.cursorContext));
                }
            }
            this.apply = AsyncApply.EMPTY;
        }

        public void applyAsync() throws IOException {
            if (this.apply != null) {
                throw new IllegalStateException("Already applied");
            }
            if (!IndexUpdatesWorkSync.this.parallelApply) {
                this.addSingleUpdates();
                this.apply = !this.updates.isEmpty() ? IndexUpdatesWorkSync.this.workSync.applyAsync((Work)new IndexUpdatesWork(IndexUpdatesWorkSync.combinedUpdates(this.updates), this.cursorContext)) : AsyncApply.EMPTY;
                return;
            }
            try {
                this.apply();
            }
            catch (ExecutionException e) {
                throw this.wrapExecutionException(e);
            }
        }
    }

    private static class IndexUpdatesWork
    implements Work<IndexUpdateListener, IndexUpdatesWork> {
        private final List<OneWork> works = new ArrayList<OneWork>(1);

        IndexUpdatesWork(Iterable<IndexEntryUpdate<IndexDescriptor>> updates, CursorContext cursorContext) {
            this.works.add(new OneWork(updates, cursorContext));
        }

        public IndexUpdatesWork combine(IndexUpdatesWork work) {
            this.works.addAll(work.works);
            return this;
        }

        public void apply(IndexUpdateListener material) {
            try {
                for (OneWork work : this.works) {
                    material.applyUpdates(work.updates, work.cursorContext, false);
                }
            }
            catch (IOException | KernelException e) {
                throw new UnderlyingStorageException(e);
            }
        }

        record OneWork(Iterable<IndexEntryUpdate<IndexDescriptor>> updates, CursorContext cursorContext) {
        }
    }
}

