/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.stats;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.annotations.documented.ReporterFactory;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.MultiRootGBPTree;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.index.internal.gbptree.TreeFileNotFoundException;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.async.AsyncBlockAccessor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.CommonDatabaseStores;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCacheOpenOptions;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.FileFlushEvent;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.api.index.IndexUsageStats;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsKey;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsLayout;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsValue;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsVisitor;
import org.neo4j.kernel.impl.api.index.stats.IndexUsageStatsConsumer;
import org.neo4j.kernel.impl.index.schema.ConsistencyCheckable;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class IndexStatisticsStore
extends LifecycleAdapter
implements IndexStatisticsVisitor.Visitable,
ConsistencyCheckable,
IndexUsageStatsConsumer {
    private static final IndexStatisticsValue EMPTY_STATISTICS = new IndexStatisticsValue();
    private final PageCache pageCache;
    private final FileSystemAbstraction fileSystem;
    private final Path path;
    private final RecoveryCleanupWorkCollector recoveryCleanupWorkCollector;
    private final String databaseName;
    private final PageCacheTracer pageCacheTracer;
    private final IndexStatisticsLayout layout;
    private final boolean readOnly;
    private GBPTree<IndexStatisticsKey, IndexStatisticsValue> tree;
    private final ConcurrentHashMap<IndexStatisticsKey, IndexStatisticsValue> cache = new ConcurrentHashMap();

    public IndexStatisticsStore(PageCache pageCache, FileSystemAbstraction fileSystem, DatabaseLayout databaseLayout, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, boolean readOnly, CursorContextFactory contextFactory, PageCacheTracer pageCacheTracer, ImmutableSet<OpenOption> openOptions) throws IOException {
        this(pageCache, fileSystem, databaseLayout.pathForStore(CommonDatabaseStores.INDEX_STATISTICS), recoveryCleanupWorkCollector, readOnly, databaseLayout.getDatabaseName(), contextFactory, pageCacheTracer, openOptions);
    }

    public IndexStatisticsStore(PageCache pageCache, FileSystemAbstraction fileSystem, Path path, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, boolean readOnly, String databaseName, CursorContextFactory contextFactory, PageCacheTracer pageCacheTracer, ImmutableSet<OpenOption> openOptions) throws IOException {
        this.pageCache = pageCache;
        this.fileSystem = fileSystem;
        this.path = path;
        this.recoveryCleanupWorkCollector = recoveryCleanupWorkCollector;
        this.databaseName = databaseName;
        this.pageCacheTracer = pageCacheTracer;
        this.layout = new IndexStatisticsLayout();
        this.readOnly = readOnly;
        this.initTree(contextFactory, openOptions);
    }

    private void initTree(CursorContextFactory contextFactory, ImmutableSet<OpenOption> openOptions) throws IOException {
        try {
            this.tree = new GBPTree(this.pageCache, this.fileSystem, this.path, (Layout)this.layout, MultiRootGBPTree.NO_MONITOR, MultiRootGBPTree.NO_HEADER_READER, this.recoveryCleanupWorkCollector, this.readOnly, openOptions.newWithout((Object)PageCacheOpenOptions.MULTI_VERSIONED), this.databaseName, "Statistics store", contextFactory, this.pageCacheTracer);
            try (CursorContext cursorContext = contextFactory.create("indexStatisticScan");){
                this.scanTree(this.cache::put, cursorContext);
            }
        }
        catch (TreeFileNotFoundException e) {
            throw new IllegalStateException("Index statistics store file could not be found, most likely this database needs to be recovered, file:" + String.valueOf(this.path), e);
        }
    }

    @Override
    public void addUsageStats(long indexId, IndexUsageStats added) {
        IndexStatisticsValue newValue = new IndexStatisticsValue();
        newValue.set(0, added.lastRead());
        newValue.set(1, added.readCount());
        newValue.set(2, added.trackedSince());
        this.cache.compute(new IndexStatisticsKey(indexId, 1), (key, currentValue) -> {
            if (currentValue != null) {
                newValue.set(1, added.readCount() + currentValue.get(1));
                newValue.set(2, Long.min(currentValue.get(2), added.trackedSince()));
                newValue.set(0, Long.max(currentValue.get(0), added.lastRead()));
            }
            return newValue;
        });
    }

    public IndexUsageStats usageStats(long indexId) {
        return this.get(indexId, (byte)1, stats -> new IndexUsageStats(stats.get(0), stats.get(1), stats.get(2)));
    }

    public IndexSample indexSample(long indexId) {
        return this.get(indexId, (byte)0, stats -> new IndexSample(stats.get(3), stats.get(0), stats.get(1), stats.get(2)));
    }

    private <T> T get(long indexId, byte type, Function<IndexStatisticsValue, T> converter) {
        IndexStatisticsValue value = this.cache.getOrDefault(new IndexStatisticsKey(indexId, type), EMPTY_STATISTICS);
        return converter.apply(value);
    }

    public void setSampleStats(long indexId, IndexSample sample) {
        IndexStatisticsValue value = new IndexStatisticsValue();
        value.set(0, sample.uniqueValues());
        value.set(1, sample.sampleSize());
        value.set(2, sample.updates());
        value.set(3, sample.indexSize());
        this.cache.put(new IndexStatisticsKey(indexId, 0), value);
    }

    public void removeIndex(long indexId) {
        this.cache.remove(new IndexStatisticsKey(indexId, 0));
        this.cache.remove(new IndexStatisticsKey(indexId, 1));
    }

    public void incrementIndexUpdates(long indexId, long delta) {
        this.cache.computeIfPresent(new IndexStatisticsKey(indexId, 0), (key, existing) -> {
            IndexStatisticsValue copy = existing.copy();
            copy.set(2, copy.get(2) + delta);
            return copy;
        });
    }

    @Override
    public void visit(IndexStatisticsVisitor visitor, CursorContext cursorContext) {
        try {
            this.scanTree((key, value) -> {
                switch (key.getType()) {
                    case 0: {
                        visitor.visitSampleStatistics(key.getIndexId(), value.get(0), value.get(1), value.get(2), value.get(3));
                        break;
                    }
                    case 1: {
                        visitor.visitUsageStatistics(key.getIndexId(), value.get(0), value.get(1), value.get(2));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown key type for " + String.valueOf(key));
                    }
                }
            }, cursorContext);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void checkpoint(FileFlushEvent flushEvent, AsyncBlockAccessor asyncBlockAccessor, CursorContext cursorContext) throws IOException {
        this.clearTree(cursorContext);
        this.writeCacheContentsIntoTree(cursorContext);
        this.tree.checkpoint(flushEvent, asyncBlockAccessor, cursorContext);
    }

    public boolean consistencyCheck(ReporterFactory reporterFactory, CursorContextFactory contextFactory, int numThreads, ProgressMonitorFactory progressMonitorFactory) {
        return this.tree.consistencyCheck(reporterFactory, contextFactory, numThreads, progressMonitorFactory);
    }

    private void scanTree(BiConsumer<IndexStatisticsKey, IndexStatisticsValue> consumer, CursorContext cursorContext) throws IOException {
        IndexStatisticsKey high = this.layout.newKey();
        IndexStatisticsKey low = this.layout.newKey();
        this.layout.initializeAsHighest(high);
        this.layout.initializeAsLowest(low);
        try (Seeker seek = this.tree.seek((Object)low, (Object)high, cursorContext);){
            while (seek.next()) {
                IndexStatisticsKey key = this.layout.copyKey((IndexStatisticsKey)seek.key(), new IndexStatisticsKey());
                IndexStatisticsValue value = ((IndexStatisticsValue)seek.value()).copy();
                consumer.accept(key, value);
            }
        }
    }

    private void clearTree(CursorContext cursorContext) throws IOException {
        ArrayList keys = new ArrayList(this.cache.size());
        this.scanTree((key, value) -> keys.add(key), cursorContext);
        try (Writer writer = this.tree.writer(1, cursorContext);){
            for (IndexStatisticsKey key2 : keys) {
                writer.remove((Object)key2);
            }
        }
    }

    private void writeCacheContentsIntoTree(CursorContext cursorContext) throws IOException {
        try (Writer writer = this.tree.writer(1, cursorContext);){
            for (Map.Entry<IndexStatisticsKey, IndexStatisticsValue> entry : this.cache.entrySet()) {
                writer.put((Object)entry.getKey(), (Object)entry.getValue());
            }
        }
    }

    public Path storeFile() {
        return this.path;
    }

    public void shutdown() throws IOException {
        if (this.tree != null) {
            this.tree.close();
        }
    }
}

