/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api;

import java.util.Arrays;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.UpdateMode;

public class TokenIndexEntryUpdate<INDEX_KEY extends SchemaDescriptorSupplier>
extends IndexEntryUpdate<INDEX_KEY> {
    static long NO_TX_ID = -1L;
    private final long[] before;
    private final long[] values;
    private final long txId;

    TokenIndexEntryUpdate(long entityId, INDEX_KEY index_key, long[] before, long[] values, long txId) {
        super(entityId, index_key, UpdateMode.CHANGED);
        this.before = before;
        this.values = values;
        this.txId = txId;
    }

    public long[] values() {
        return this.values;
    }

    public long[] beforeValues() {
        if (this.before == null) {
            throw new UnsupportedOperationException("beforeValues is only valid for `UpdateMode.CHANGED");
        }
        return this.before;
    }

    public long txId() {
        return this.txId;
    }

    @Override
    public long roughSizeOfUpdate() {
        return HeapEstimator.sizeOf((long[])this.values) + (this.updateMode() == UpdateMode.CHANGED ? HeapEstimator.sizeOf((long[])this.before) : 0L);
    }

    @Override
    protected boolean valueEquals(IndexEntryUpdate<?> o) {
        if (!(o instanceof TokenIndexEntryUpdate)) {
            return false;
        }
        TokenIndexEntryUpdate that = (TokenIndexEntryUpdate)o;
        if (!Arrays.equals(this.before, that.before)) {
            return false;
        }
        return Arrays.equals(this.values, that.values);
    }

    @Override
    protected int valueHash() {
        int result = Arrays.hashCode(this.before);
        result = 31 * result + Arrays.hashCode(this.values);
        return result;
    }

    @Override
    protected String valueToString() {
        return String.format("beforeValues=%s, values=%s, txId=%d", Arrays.toString(this.before), Arrays.toString(this.values), this.txId);
    }
}

