/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api.txstate;

import java.util.Iterator;
import java.util.function.Function;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.storageengine.api.StorageProperty;

public interface TxStateVisitor
extends AutoCloseable {
    public static final TxStateVisitor EMPTY = new Adapter();
    public static final Decorator NO_DECORATION = txStateVisitor -> txStateVisitor;

    public void visitCreatedNode(long var1);

    public void visitDeletedNode(long var1);

    public void visitCreatedRelationship(long var1, int var3, long var4, long var6) throws ConstraintValidationException;

    public void visitDeletedRelationship(long var1);

    public void visitNodePropertyChanges(long var1, Iterator<StorageProperty> var3, Iterator<StorageProperty> var4, IntIterable var5) throws ConstraintValidationException;

    public void visitRelPropertyChanges(long var1, Iterator<StorageProperty> var3, Iterator<StorageProperty> var4, IntIterable var5) throws ConstraintValidationException;

    public void visitNodeLabelChanges(long var1, LongSet var3, LongSet var4) throws ConstraintValidationException;

    public void visitAddedIndex(IndexDescriptor var1) throws KernelException;

    public void visitRemovedIndex(IndexDescriptor var1);

    public void visitAddedConstraint(ConstraintDescriptor var1) throws KernelException;

    public void visitRemovedConstraint(ConstraintDescriptor var1);

    public void visitCreatedLabelToken(long var1, String var3, boolean var4);

    public void visitCreatedPropertyKeyToken(long var1, String var3, boolean var4);

    public void visitCreatedRelationshipTypeToken(long var1, String var3, boolean var4);

    @Override
    public void close();

    public static interface Decorator
    extends Function<TxStateVisitor, TxStateVisitor> {
    }

    public static class Delegator
    implements TxStateVisitor {
        private final TxStateVisitor actual;

        public Delegator(TxStateVisitor actual) {
            assert (actual != null);
            this.actual = actual;
        }

        @Override
        public void visitCreatedNode(long id) {
            this.actual.visitCreatedNode(id);
        }

        @Override
        public void visitDeletedNode(long id) {
            this.actual.visitDeletedNode(id);
        }

        @Override
        public void visitCreatedRelationship(long id, int type, long startNode, long endNode) throws ConstraintValidationException {
            this.actual.visitCreatedRelationship(id, type, startNode, endNode);
        }

        @Override
        public void visitDeletedRelationship(long id) {
            this.actual.visitDeletedRelationship(id);
        }

        @Override
        public void visitNodePropertyChanges(long id, Iterator<StorageProperty> added, Iterator<StorageProperty> changed, IntIterable removed) throws ConstraintValidationException {
            this.actual.visitNodePropertyChanges(id, added, changed, removed);
        }

        @Override
        public void visitRelPropertyChanges(long id, Iterator<StorageProperty> added, Iterator<StorageProperty> changed, IntIterable removed) throws ConstraintValidationException {
            this.actual.visitRelPropertyChanges(id, added, changed, removed);
        }

        @Override
        public void visitNodeLabelChanges(long id, LongSet added, LongSet removed) throws ConstraintValidationException {
            this.actual.visitNodeLabelChanges(id, added, removed);
        }

        @Override
        public void visitAddedIndex(IndexDescriptor index) throws KernelException {
            this.actual.visitAddedIndex(index);
        }

        @Override
        public void visitRemovedIndex(IndexDescriptor index) {
            this.actual.visitRemovedIndex(index);
        }

        @Override
        public void visitAddedConstraint(ConstraintDescriptor constraint) throws KernelException {
            this.actual.visitAddedConstraint(constraint);
        }

        @Override
        public void visitRemovedConstraint(ConstraintDescriptor constraint) {
            this.actual.visitRemovedConstraint(constraint);
        }

        @Override
        public void visitCreatedLabelToken(long id, String name, boolean internal) {
            this.actual.visitCreatedLabelToken(id, name, internal);
        }

        @Override
        public void visitCreatedPropertyKeyToken(long id, String name, boolean internal) {
            this.actual.visitCreatedPropertyKeyToken(id, name, internal);
        }

        @Override
        public void visitCreatedRelationshipTypeToken(long id, String name, boolean internal) {
            this.actual.visitCreatedRelationshipTypeToken(id, name, internal);
        }

        @Override
        public void close() {
            this.actual.close();
        }
    }

    public static class Adapter
    implements TxStateVisitor {
        @Override
        public void visitCreatedNode(long id) {
        }

        @Override
        public void visitDeletedNode(long id) {
        }

        @Override
        public void visitCreatedRelationship(long id, int type, long startNode, long endNode) {
        }

        @Override
        public void visitDeletedRelationship(long id) {
        }

        @Override
        public void visitNodePropertyChanges(long id, Iterator<StorageProperty> added, Iterator<StorageProperty> changed, IntIterable removed) {
        }

        @Override
        public void visitRelPropertyChanges(long id, Iterator<StorageProperty> added, Iterator<StorageProperty> changed, IntIterable removed) {
        }

        @Override
        public void visitNodeLabelChanges(long id, LongSet added, LongSet removed) {
        }

        @Override
        public void visitAddedIndex(IndexDescriptor index) throws KernelException {
        }

        @Override
        public void visitRemovedIndex(IndexDescriptor index) {
        }

        @Override
        public void visitAddedConstraint(ConstraintDescriptor element) throws KernelException {
        }

        @Override
        public void visitRemovedConstraint(ConstraintDescriptor element) {
        }

        @Override
        public void visitCreatedLabelToken(long id, String name, boolean internal) {
        }

        @Override
        public void visitCreatedPropertyKeyToken(long id, String name, boolean internal) {
        }

        @Override
        public void visitCreatedRelationshipTypeToken(long id, String name, boolean internal) {
        }

        @Override
        public void close() {
        }
    }
}

