/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api.txstate;

import java.io.Serializable;
import java.util.function.LongConsumer;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.io.IOUtils;
import org.neo4j.storageengine.api.CountsDelta;
import org.neo4j.storageengine.api.StorageCursor;
import org.neo4j.storageengine.api.StorageNodeCursor;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StorageRelationshipGroupCursor;
import org.neo4j.storageengine.api.StorageRelationshipScanCursor;
import org.neo4j.storageengine.api.txstate.DegreeVisitor;
import org.neo4j.storageengine.api.txstate.LongDiffSets;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;

public class TransactionCountingStateVisitor
extends TxStateVisitor.Delegator {
    private final CountsDelta counts;
    private final ReadableTransactionState txState;
    private final StorageNodeCursor nodeCursor;
    private final StorageRelationshipGroupCursor groupCursor;
    private final StorageRelationshipScanCursor relationshipCursor;

    public TransactionCountingStateVisitor(TxStateVisitor next, StorageReader storageReader, ReadableTransactionState txState, CountsDelta counts) {
        super(next);
        this.txState = txState;
        this.counts = counts;
        this.nodeCursor = storageReader.allocateNodeCursor();
        this.groupCursor = storageReader.allocateRelationshipGroupCursor();
        this.relationshipCursor = storageReader.allocateRelationshipScanCursor();
    }

    @Override
    public void visitCreatedNode(long id) {
        this.counts.incrementNodeCount(-1L, 1L);
        super.visitCreatedNode(id);
    }

    @Override
    public void visitDeletedNode(long id) {
        this.counts.incrementNodeCount(-1L, -1L);
        this.nodeCursor.single(id);
        if (this.nodeCursor.next()) {
            this.decrementCountForLabelsAndRelationships(this.nodeCursor);
        }
        super.visitDeletedNode(id);
    }

    private void decrementCountForLabelsAndRelationships(StorageNodeCursor node) {
        long[] labelIds;
        for (long labelId : labelIds = node.labels()) {
            this.counts.incrementNodeCount(labelId, -1L);
        }
        this.visitDegrees(node, (type, out, in) -> this.updateRelationshipsCountsFromDegrees(labelIds, type, -out, -in));
    }

    private void visitDegrees(StorageNodeCursor node, DegreeVisitor visitor) {
        this.groupCursor.init(node.entityReference(), node.relationshipGroupReference(), node.isDense());
        while (this.groupCursor.next()) {
            int loopCount = this.groupCursor.loopCount();
            visitor.visitDegree(this.groupCursor.type(), this.groupCursor.outgoingCount() + loopCount, this.groupCursor.incomingCount() + loopCount);
        }
    }

    @Override
    public void visitCreatedRelationship(long id, int type, long startNode, long endNode) throws ConstraintValidationException {
        this.updateRelationshipCount(startNode, type, endNode, 1);
        super.visitCreatedRelationship(id, type, startNode, endNode);
    }

    @Override
    public void visitDeletedRelationship(long id) {
        this.relationshipCursor.single(id);
        if (!this.relationshipCursor.next()) {
            throw new IllegalStateException("Relationship being deleted should exist along with its nodes. Relationship[" + id + "]");
        }
        this.updateRelationshipCount(this.relationshipCursor.sourceNodeReference(), this.relationshipCursor.type(), this.relationshipCursor.targetNodeReference(), -1);
        super.visitDeletedRelationship(id);
    }

    @Override
    public void visitNodeLabelChanges(long id, LongSet added, LongSet removed) throws ConstraintValidationException {
        if (!added.isEmpty() || !removed.isEmpty()) {
            added.each((LongProcedure & Serializable)label -> this.counts.incrementNodeCount(label, 1L));
            removed.each((LongProcedure & Serializable)label -> this.counts.incrementNodeCount(label, -1L));
            this.nodeCursor.single(id);
            if (this.nodeCursor.next()) {
                this.visitDegrees(this.nodeCursor, (type, out, in) -> {
                    added.forEach((LongProcedure & Serializable)label -> this.updateRelationshipsCountsFromDegrees(type, label, out, in));
                    removed.forEach((LongProcedure & Serializable)label -> this.updateRelationshipsCountsFromDegrees(type, label, -out, -in));
                });
            }
        }
        super.visitNodeLabelChanges(id, added, removed);
    }

    private void updateRelationshipsCountsFromDegrees(long[] labels, int type, long outgoing, long incoming) {
        for (long label : labels) {
            this.updateRelationshipsCountsFromDegrees(type, label, outgoing, incoming);
        }
    }

    private boolean updateRelationshipsCountsFromDegrees(int type, long label, long outgoing, long incoming) {
        this.counts.incrementRelationshipCount(label, -1, -1L, outgoing);
        this.counts.incrementRelationshipCount(-1L, -1, label, incoming);
        this.counts.incrementRelationshipCount(label, type, -1L, outgoing);
        this.counts.incrementRelationshipCount(-1L, type, label, incoming);
        return false;
    }

    private void updateRelationshipCount(long startNode, int type, long endNode, int delta) {
        this.updateRelationshipsCountsFromDegrees(type, -1L, (long)delta, 0L);
        this.visitLabels(startNode, labelId -> this.updateRelationshipsCountsFromDegrees(type, labelId, (long)delta, 0L));
        this.visitLabels(endNode, labelId -> this.updateRelationshipsCountsFromDegrees(type, labelId, 0L, (long)delta));
    }

    private void visitLabels(long nodeId, LongConsumer visitor) {
        if (this.txState.nodeIsDeletedInThisTx(nodeId)) {
            return;
        }
        if (this.txState.nodeIsAddedInThisTx(nodeId)) {
            this.txState.getNodeState(nodeId).labelDiffSets().getAdded().forEach(visitor::accept);
        } else {
            this.nodeCursor.single(nodeId);
            if (this.nodeCursor.next()) {
                long[] labels = this.nodeCursor.labels();
                LongDiffSets labelDiff = this.txState.getNodeState(nodeId).labelDiffSets();
                labelDiff.getAdded().forEach(visitor::accept);
                for (long label : labels) {
                    if (labelDiff.isRemoved(label)) continue;
                    visitor.accept(label);
                }
            }
        }
    }

    @Override
    public void close() {
        super.close();
        IOUtils.closeAllUnchecked((AutoCloseable[])new StorageCursor[]{this.nodeCursor, this.groupCursor, this.relationshipCursor});
    }
}

