/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api;

public enum RelationshipDirection {
    OUTGOING,
    INCOMING,
    LOOP,
    ERROR;


    public static RelationshipDirection directionOfStrict(long nodeReference, long sourceNodeReference, long targetNodeReference) {
        if (sourceNodeReference == nodeReference) {
            return targetNodeReference == nodeReference ? LOOP : OUTGOING;
        }
        if (targetNodeReference == nodeReference) {
            return INCOMING;
        }
        throw new IllegalStateException("Traversed relationship that wasn't part of the origin node:" + nodeReference + ". The encountered relationship has source:" + sourceNodeReference + " and target:" + targetNodeReference);
    }

    public static RelationshipDirection directionOf(long nodeReference, long sourceNodeReference, long targetNodeReference) {
        if (sourceNodeReference == nodeReference) {
            return targetNodeReference == nodeReference ? LOOP : OUTGOING;
        }
        if (targetNodeReference == nodeReference) {
            return INCOMING;
        }
        return ERROR;
    }
}

