/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import java.nio.file.Path;
import org.neo4j.collection.Dependencies;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseContextProvider;
import org.neo4j.function.Suppliers;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.internal.kernel.api.security.AbstractSecurityLog;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.api.security.SecurityModule;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.server.security.SecureHasher;
import org.neo4j.server.security.auth.AuthProcedures;
import org.neo4j.server.security.auth.AuthenticationStrategy;
import org.neo4j.server.security.auth.FileUserRepository;
import org.neo4j.server.security.auth.RateLimitedAuthenticationStrategy;
import org.neo4j.server.security.systemgraph.BasicSystemGraphRealm;
import org.neo4j.server.security.systemgraph.SystemGraphRealmHelper;
import org.neo4j.server.security.systemgraph.UserSecurityGraphComponent;
import org.neo4j.time.Clocks;

public class CommunitySecurityModule
extends SecurityModule {
    private final InternalLogProvider debugLogProvider;
    private final Config config;
    private final Dependencies globalDependencies;
    private BasicSystemGraphRealm authManager;
    private static final String INITIAL_USER_STORE_FILENAME = "auth.ini";

    public CommunitySecurityModule(LogService logService, Config config, Dependencies globalDependencies) {
        this.debugLogProvider = logService.getInternalLogProvider();
        this.config = config;
        this.globalDependencies = globalDependencies;
    }

    public void setup() {
        Suppliers.Lazy systemSupplier = Suppliers.lazySingleton(() -> {
            DatabaseContextProvider databaseContextProvider = (DatabaseContextProvider)this.globalDependencies.resolveDependency(DatabaseContextProvider.class);
            return ((DatabaseContext)databaseContextProvider.getDatabaseContext(NamedDatabaseId.NAMED_SYSTEM_DATABASE_ID).orElseThrow(() -> new RuntimeException("No database called `system` was found."))).databaseFacade();
        });
        this.authManager = new BasicSystemGraphRealm(new SystemGraphRealmHelper((Suppliers.Lazy<GraphDatabaseService>)systemSupplier, new SecureHasher()), CommunitySecurityModule.createAuthenticationStrategy(this.config));
        CommunitySecurityModule.registerProcedure((GlobalProcedures)((GlobalProcedures)this.globalDependencies.resolveDependency(GlobalProcedures.class)), (InternalLog)this.debugLogProvider.getLog(((Object)((Object)this)).getClass()), AuthProcedures.class);
    }

    public AuthManager authManager() {
        return this.authManager;
    }

    public AuthManager inClusterAuthManager() {
        return null;
    }

    public AuthManager loopbackAuthManager() {
        return null;
    }

    private static FileUserRepository getInitialUserRepository(Config config, InternalLogProvider logProvider, FileSystemAbstraction fileSystem, MemoryTracker memoryTracker) {
        return new FileUserRepository(fileSystem, CommunitySecurityModule.getInitialUserRepositoryFile(config), logProvider, memoryTracker);
    }

    public static Path getInitialUserRepositoryFile(Config config) {
        Path authStoreDir = (Path)config.get(GraphDatabaseInternalSettings.auth_store_directory);
        return authStoreDir.resolve(INITIAL_USER_STORE_FILENAME);
    }

    public static UserSecurityGraphComponent createSecurityComponent(Config config, FileSystemAbstraction fileSystem, InternalLogProvider logProvider, AbstractSecurityLog securityLog, MemoryTracker memoryTracker) {
        FileUserRepository initialUserRepository = CommunitySecurityModule.getInitialUserRepository(config, logProvider, fileSystem, memoryTracker);
        return new UserSecurityGraphComponent(initialUserRepository, config, (LogProvider)logProvider, securityLog);
    }

    public static AuthenticationStrategy createAuthenticationStrategy(Config config) {
        return new RateLimitedAuthenticationStrategy(Clocks.systemClock(), config);
    }
}

