/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import org.neo4j.cypher.internal.security.FormatException;
import org.neo4j.cypher.internal.security.SecureHasher;
import org.neo4j.cypher.internal.security.SecureHasherConfigurations;
import org.neo4j.cypher.internal.security.SystemGraphCredential;
import org.neo4j.exceptions.InvalidArgumentException;
import org.neo4j.internal.helpers.Format;
import org.neo4j.kernel.impl.security.Credential;
import org.neo4j.kernel.impl.security.User;
import org.neo4j.server.security.auth.FileRepositorySerializer;
import org.neo4j.server.security.auth.LegacyCredential;

public class UserSerialization
extends FileRepositorySerializer<User> {
    private static final String userSeparator = ":";

    @Override
    protected String serialize(User user) {
        return String.join((CharSequence)userSeparator, user.name(), user.credentials().serialize(), String.join((CharSequence)",", user.getFlags()));
    }

    @Override
    protected User deserializeRecord(String line, int lineNumber) throws FormatException {
        String[] parts = line.split(userSeparator, -1);
        if (parts.length != 3) {
            throw new FormatException(String.format("wrong number of line fields, expected 3, got %d [line %d]", parts.length, lineNumber));
        }
        User.Builder b = new User.Builder(parts[0], UserSerialization.deserializeCredentials(parts[1], lineNumber));
        for (String flag : parts[2].split(",", -1)) {
            String trimmed = flag.trim();
            if (trimmed.isEmpty()) continue;
            b = b.withFlag(trimmed);
        }
        return b.build();
    }

    protected static String serialize(LegacyCredential cred) {
        return cred.serialize();
    }

    private static Credential deserializeCredentials(String part, int lineNumber) throws FormatException {
        String hasherVersion;
        int iterations;
        String[] split = part.split(",", -1);
        String algorithm = split[0];
        if (split.length == 4) {
            iterations = Integer.parseInt(split[3]);
        } else if (split.length == 3) {
            iterations = 1;
        } else {
            throw new FormatException(String.format("wrong number of credential fields [line %d]", lineNumber));
        }
        try {
            hasherVersion = SecureHasherConfigurations.getVersionForConfiguration((String)algorithm, (int)iterations);
        }
        catch (InvalidArgumentException e) {
            throw new FormatException(String.format("unknown digest \"%s\" [line %d]:", part, lineNumber));
        }
        if (hasherVersion.equals("0")) {
            byte[] decodedPassword = Format.parseHexString((String)split[1]);
            byte[] decodedSalt = Format.parseHexString((String)split[2]);
            return new LegacyCredential(decodedSalt, decodedPassword);
        }
        return SystemGraphCredential.deserialize((String)part, (SecureHasher)new SecureHasher(hasherVersion));
    }
}

