/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.systemgraph;

public enum ComponentVersion {
    COMMUNITY_SECURITY_35(0, "security-users", "Neo4j 3.5"),
    COMMUNITY_SECURITY_40(1, "security-users", "Neo4j 4.0"),
    COMMUNITY_SECURITY_41(2, "security-users", "Neo4j 4.1"),
    COMMUNITY_SECURITY_UNKNOWN_VERSION(-1, "security-users", String.format("no '%s' graph found", "security-users")),
    ENTERPRISE_SECURITY_35(0, "security-privileges", "Neo4j 3.5"),
    ENTERPRISE_SECURITY_36(1, "security-privileges", "Neo4j 3.6"),
    ENTERPRISE_SECURITY_40(2, "security-privileges", "Neo4j 4.0"),
    ENTERPRISE_SECURITY_41D1(3, "security-privileges", "Neo4j 4.1.0-Drop01"),
    ENTERPRISE_SECURITY_41(4, "security-privileges", "Neo4j 4.1"),
    ENTERPRISE_SECURITY_42D4(5, "security-privileges", "Neo4j 4.2.0-Drop04"),
    ENTERPRISE_SECURITY_42D6(6, "security-privileges", "Neo4j 4.2.0-Drop06"),
    ENTERPRISE_SECURITY_42D7(7, "security-privileges", "Neo4j 4.2.0-Drop07"),
    ENTERPRISE_SECURITY_42P1(8, "security-privileges", "Neo4j 4.2.1"),
    ENTERPRISE_SECURITY_UNKNOWN_VERSION(-1, "security-privileges", String.format("no '%s' graph found", "security-privileges")),
    ENTERPRISE_SECURITY_FUTURE_VERSION(Integer.MIN_VALUE, "security-privileges", "Unrecognized future version"),
    ENTERPRISE_SECURITY_FAKE_VERSION(Integer.MAX_VALUE, "security-privileges", "Neo4j 8.8.88");

    public static final int FIRST_VALID_COMMUNITY_SECURITY_COMPONENT_VERSION;
    public static final int FIRST_RUNTIME_SUPPORTED_COMMUNITY_SECURITY_COMPONENT_VERSION;
    public static final int LATEST_COMMUNITY_SECURITY_COMPONENT_VERSION;
    public static final int FIRST_VALID_ENTERPRISE_SECURITY_COMPONENT_VERSION;
    public static final int FIRST_RUNTIME_SUPPORTED_ENTERPRISE_SECURITY_COMPONENT_VERSION;
    public static final int LATEST_ENTERPRISE_SECURITY_COMPONENT_VERSION;
    private final String componentName;
    private final int version;
    private final String description;

    private ComponentVersion(int version, String componentName, String description) {
        this.version = version;
        this.componentName = componentName;
        this.description = description;
    }

    public int getVersion() {
        return this.version;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getDescription() {
        return this.description;
    }

    boolean isCurrent() {
        if (this.componentName.equals("security-users")) {
            return this.version == LATEST_COMMUNITY_SECURITY_COMPONENT_VERSION;
        }
        if (this.componentName.equals("security-privileges")) {
            return this.version == LATEST_ENTERPRISE_SECURITY_COMPONENT_VERSION;
        }
        return false;
    }

    public boolean migrationSupported() {
        if (this.componentName.equals("security-users")) {
            return this.version >= FIRST_VALID_COMMUNITY_SECURITY_COMPONENT_VERSION && this.version <= LATEST_COMMUNITY_SECURITY_COMPONENT_VERSION;
        }
        if (this.componentName.equals("security-privileges")) {
            return this.version >= FIRST_VALID_ENTERPRISE_SECURITY_COMPONENT_VERSION && this.version <= LATEST_ENTERPRISE_SECURITY_COMPONENT_VERSION;
        }
        return false;
    }

    public boolean runtimeSupported() {
        if (this.componentName.equals("security-users")) {
            return this.version >= FIRST_RUNTIME_SUPPORTED_COMMUNITY_SECURITY_COMPONENT_VERSION && this.version <= LATEST_COMMUNITY_SECURITY_COMPONENT_VERSION;
        }
        if (this.componentName.equals("security-privileges")) {
            return this.version >= FIRST_RUNTIME_SUPPORTED_ENTERPRISE_SECURITY_COMPONENT_VERSION && this.version <= LATEST_ENTERPRISE_SECURITY_COMPONENT_VERSION;
        }
        return false;
    }

    static {
        FIRST_VALID_COMMUNITY_SECURITY_COMPONENT_VERSION = COMMUNITY_SECURITY_35.getVersion();
        FIRST_RUNTIME_SUPPORTED_COMMUNITY_SECURITY_COMPONENT_VERSION = COMMUNITY_SECURITY_40.getVersion();
        LATEST_COMMUNITY_SECURITY_COMPONENT_VERSION = COMMUNITY_SECURITY_41.getVersion();
        FIRST_VALID_ENTERPRISE_SECURITY_COMPONENT_VERSION = ENTERPRISE_SECURITY_35.getVersion();
        FIRST_RUNTIME_SUPPORTED_ENTERPRISE_SECURITY_COMPONENT_VERSION = ENTERPRISE_SECURITY_40.getVersion();
        LATEST_ENTERPRISE_SECURITY_COMPONENT_VERSION = ENTERPRISE_SECURITY_42P1.getVersion();
    }

    public static class Neo4jVersions {
        public static final String VERSION_35 = "Neo4j 3.5";
        public static final String VERSION_36 = "Neo4j 3.6";
        public static final String VERSION_40 = "Neo4j 4.0";
        public static final String VERSION_41D1 = "Neo4j 4.1.0-Drop01";
        public static final String VERSION_41 = "Neo4j 4.1";
        public static final String VERSION_42D4 = "Neo4j 4.2.0-Drop04";
        public static final String VERSION_42D6 = "Neo4j 4.2.0-Drop06";
        public static final String VERSION_42D7 = "Neo4j 4.2.0-Drop07";
        public static final String VERSION_42P1 = "Neo4j 4.2.1";
        public static final int UNKNOWN_VERSION = -1;
    }
}

