/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth;

import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.util.ByteSource;
import org.neo4j.kernel.api.security.AuthenticationResult;

public class ShiroAuthenticationInfo
extends SimpleAuthenticationInfo {
    private AuthenticationResult authenticationResult;
    private static AuthenticationResult[][] mergeMatrix = new AuthenticationResult[][]{{AuthenticationResult.SUCCESS, AuthenticationResult.SUCCESS, AuthenticationResult.SUCCESS, AuthenticationResult.PASSWORD_CHANGE_REQUIRED}, {AuthenticationResult.SUCCESS, AuthenticationResult.FAILURE, AuthenticationResult.TOO_MANY_ATTEMPTS, AuthenticationResult.PASSWORD_CHANGE_REQUIRED}, {AuthenticationResult.SUCCESS, AuthenticationResult.TOO_MANY_ATTEMPTS, AuthenticationResult.TOO_MANY_ATTEMPTS, AuthenticationResult.PASSWORD_CHANGE_REQUIRED}, {AuthenticationResult.PASSWORD_CHANGE_REQUIRED, AuthenticationResult.PASSWORD_CHANGE_REQUIRED, AuthenticationResult.PASSWORD_CHANGE_REQUIRED, AuthenticationResult.PASSWORD_CHANGE_REQUIRED}};

    public ShiroAuthenticationInfo() {
        this.authenticationResult = AuthenticationResult.FAILURE;
    }

    public ShiroAuthenticationInfo(Object principal, String realmName, AuthenticationResult authenticationResult) {
        super(principal, null, realmName);
        this.authenticationResult = authenticationResult;
    }

    public ShiroAuthenticationInfo(Object principal, Object hashedCredentials, ByteSource credentialsSalt, String realmName, AuthenticationResult authenticationResult) {
        super(principal, hashedCredentials, credentialsSalt, realmName);
        this.authenticationResult = authenticationResult;
    }

    public AuthenticationResult getAuthenticationResult() {
        return this.authenticationResult;
    }

    public void merge(AuthenticationInfo info) {
        if (info == null || info.getPrincipals() == null || info.getPrincipals().isEmpty()) {
            return;
        }
        super.merge(info);
        this.authenticationResult = info instanceof ShiroAuthenticationInfo ? ShiroAuthenticationInfo.mergeAuthenticationResult(this.authenticationResult, ((ShiroAuthenticationInfo)info).getAuthenticationResult()) : ShiroAuthenticationInfo.mergeAuthenticationResult(this.authenticationResult, AuthenticationResult.SUCCESS);
    }

    private static AuthenticationResult mergeAuthenticationResult(AuthenticationResult result, AuthenticationResult newResult) {
        AuthenticationResult mergedResult = mergeMatrix[result.ordinal()][newResult.ordinal()];
        return mergedResult;
    }
}

