/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.ExcessiveAttemptsException;
import org.apache.shiro.authc.pam.AuthenticationStrategy;
import org.apache.shiro.authc.pam.ModularRealmAuthenticator;
import org.apache.shiro.authc.pam.UnsupportedTokenException;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.mgt.DefaultSecurityManager;
import org.apache.shiro.mgt.DefaultSessionStorageEvaluator;
import org.apache.shiro.mgt.DefaultSubjectDAO;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.mgt.SessionStorageEvaluator;
import org.apache.shiro.mgt.SubjectDAO;
import org.apache.shiro.mgt.SubjectFactory;
import org.apache.shiro.realm.AuthenticatingRealm;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.realm.CachingRealm;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.util.Initializable;
import org.neo4j.graphdb.security.AuthProviderFailedException;
import org.neo4j.graphdb.security.AuthProviderTimeoutException;
import org.neo4j.helpers.Strings;
import org.neo4j.kernel.api.security.AuthToken;
import org.neo4j.kernel.api.security.AuthenticationResult;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.security.exception.InvalidAuthTokenException;
import org.neo4j.kernel.enterprise.api.security.EnterpriseSecurityContext;
import org.neo4j.server.security.enterprise.auth.EnterpriseAuthAndUserManager;
import org.neo4j.server.security.enterprise.auth.EnterpriseUserManager;
import org.neo4j.server.security.enterprise.auth.PersonalUserManager;
import org.neo4j.server.security.enterprise.auth.RealmLifecycle;
import org.neo4j.server.security.enterprise.auth.ShiroAuthToken;
import org.neo4j.server.security.enterprise.auth.ShiroAuthenticationStrategy;
import org.neo4j.server.security.enterprise.auth.ShiroAuthorizationInfoProvider;
import org.neo4j.server.security.enterprise.auth.ShiroSubject;
import org.neo4j.server.security.enterprise.auth.ShiroSubjectFactory;
import org.neo4j.server.security.enterprise.auth.StandardEnterpriseSecurityContext;
import org.neo4j.server.security.enterprise.log.SecurityLog;

class MultiRealmAuthManager
implements EnterpriseAuthAndUserManager {
    private final EnterpriseUserManager userManager;
    private final Collection<Realm> realms;
    private final DefaultSecurityManager securityManager;
    private final CacheManager cacheManager;
    private final SecurityLog securityLog;
    private final boolean logSuccessfulLogin;

    MultiRealmAuthManager(EnterpriseUserManager userManager, Collection<Realm> realms, CacheManager cacheManager, SecurityLog securityLog, boolean logSuccessfulLogin) {
        this.userManager = userManager;
        this.realms = realms;
        this.cacheManager = cacheManager;
        this.securityManager = new DefaultSecurityManager(realms);
        this.securityLog = securityLog;
        this.logSuccessfulLogin = logSuccessfulLogin;
        this.securityManager.setSubjectFactory((SubjectFactory)new ShiroSubjectFactory());
        ((ModularRealmAuthenticator)this.securityManager.getAuthenticator()).setAuthenticationStrategy((AuthenticationStrategy)new ShiroAuthenticationStrategy());
        this.securityManager.setSubjectDAO(this.createSubjectDAO());
    }

    private SubjectDAO createSubjectDAO() {
        DefaultSubjectDAO subjectDAO = new DefaultSubjectDAO();
        DefaultSessionStorageEvaluator sessionStorageEvaluator = new DefaultSessionStorageEvaluator();
        sessionStorageEvaluator.setSessionStorageEnabled(false);
        subjectDAO.setSessionStorageEvaluator((SessionStorageEvaluator)sessionStorageEvaluator);
        return subjectDAO;
    }

    public EnterpriseSecurityContext login(Map<String, Object> authToken) throws InvalidAuthTokenException {
        StandardEnterpriseSecurityContext securityContext;
        ShiroAuthToken token = new ShiroAuthToken(authToken);
        this.assertValidScheme(token);
        try {
            securityContext = new StandardEnterpriseSecurityContext(this, (ShiroSubject)this.securityManager.login(null, (AuthenticationToken)token));
            if (this.logSuccessfulLogin) {
                this.securityLog.info((SecurityContext)securityContext, "logged in");
            }
        }
        catch (UnsupportedTokenException e) {
            this.securityLog.error("Unknown user failed to log in: %s", e.getMessage());
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof InvalidAuthTokenException) {
                throw new InvalidAuthTokenException(cause.getMessage() + ": " + token);
            }
            throw AuthToken.invalidToken((String)(": " + token));
        }
        catch (ExcessiveAttemptsException e) {
            securityContext = new StandardEnterpriseSecurityContext(this, new ShiroSubject((SecurityManager)this.securityManager, AuthenticationResult.TOO_MANY_ATTEMPTS));
            this.securityLog.error("[%s]: failed to log in: too many failed attempts", Strings.escape((String)token.getPrincipal().toString()));
        }
        catch (AuthenticationException e) {
            if (e.getCause() != null && e.getCause() instanceof AuthProviderTimeoutException) {
                this.securityLog.error("[%s]: failed to log in: auth server timeout", Strings.escape((String)token.getPrincipal().toString()));
                throw new AuthProviderTimeoutException(e.getCause().getMessage(), e.getCause());
            }
            if (e.getCause() != null && e.getCause() instanceof AuthProviderFailedException) {
                this.securityLog.error("[%s]: failed to log in: auth server connection refused", Strings.escape((String)token.getPrincipal().toString()));
                throw new AuthProviderFailedException(e.getCause().getMessage(), e.getCause());
            }
            securityContext = new StandardEnterpriseSecurityContext(this, new ShiroSubject((SecurityManager)this.securityManager, AuthenticationResult.FAILURE));
            this.securityLog.error("[%s]: failed to log in: invalid principal or credentials", Strings.escape((String)token.getPrincipal().toString()));
        }
        return securityContext;
    }

    private void assertValidScheme(ShiroAuthToken token) throws InvalidAuthTokenException {
        String scheme = token.getSchemeSilently();
        if (scheme == null) {
            throw AuthToken.invalidToken((String)("missing key `scheme`: " + token));
        }
        if (scheme.equals("none")) {
            throw AuthToken.invalidToken((String)("scheme='none' only allowed when auth is disabled: " + token));
        }
    }

    public void init() throws Throwable {
        for (Realm realm : this.realms) {
            if (realm instanceof Initializable) {
                ((Initializable)realm).init();
            }
            if (realm instanceof CachingRealm) {
                ((CachingRealm)realm).setCacheManager(this.cacheManager);
            }
            if (!(realm instanceof RealmLifecycle)) continue;
            ((RealmLifecycle)realm).initialize();
        }
    }

    public void start() throws Throwable {
        for (Realm realm : this.realms) {
            if (!(realm instanceof RealmLifecycle)) continue;
            ((RealmLifecycle)realm).start();
        }
    }

    public void stop() throws Throwable {
        for (Realm realm : this.realms) {
            if (!(realm instanceof RealmLifecycle)) continue;
            ((RealmLifecycle)realm).stop();
        }
    }

    public void shutdown() throws Throwable {
        for (Realm realm : this.realms) {
            if (realm instanceof CachingRealm) {
                ((CachingRealm)realm).setCacheManager(null);
            }
            if (!(realm instanceof RealmLifecycle)) continue;
            ((RealmLifecycle)realm).shutdown();
        }
    }

    @Override
    public EnterpriseUserManager getUserManager(SecurityContext securityContext) {
        return new PersonalUserManager(this.userManager, securityContext, this.securityLog);
    }

    @Override
    public EnterpriseUserManager getUserManager() {
        return this.userManager;
    }

    public void clearAuthCache() {
        for (Realm realm : this.realms) {
            Cache cache;
            if (realm instanceof AuthenticatingRealm && (cache = ((AuthenticatingRealm)realm).getAuthenticationCache()) != null) {
                cache.clear();
            }
            if (!(realm instanceof AuthorizingRealm) || (cache = ((AuthorizingRealm)realm).getAuthorizationCache()) == null) continue;
            cache.clear();
        }
    }

    public Collection<AuthorizationInfo> getAuthorizationInfo(PrincipalCollection principalCollection) {
        ArrayList<AuthorizationInfo> infoList = new ArrayList<AuthorizationInfo>(1);
        for (Realm realm : this.realms) {
            AuthorizationInfo info;
            if (!(realm instanceof ShiroAuthorizationInfoProvider) || (info = ((ShiroAuthorizationInfoProvider)realm).getAuthorizationInfoSnapshot(principalCollection)) == null) continue;
            infoList.add(info);
        }
        return infoList;
    }
}

