/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.log;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.neo4j.helpers.Strings;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.security.AuthSubject;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.FormattedLog;
import org.neo4j.logging.Level;
import org.neo4j.logging.Log;
import org.neo4j.logging.Logger;
import org.neo4j.logging.RotatingFileOutputStreamSupplier;
import org.neo4j.logging.async.AsyncLog;
import org.neo4j.logging.async.AsyncLogEvent;
import org.neo4j.server.security.enterprise.configuration.SecuritySettings;

public class SecurityLog
extends LifecycleAdapter
implements Log {
    private RotatingFileOutputStreamSupplier rotatingSupplier;
    private final Log inner;

    public SecurityLog(Config config, FileSystemAbstraction fileSystem, Executor executor) throws IOException {
        FormattedLog.Builder builder = FormattedLog.withUTCTimeZone();
        File logFile = (File)config.get(SecuritySettings.security_log_filename);
        this.rotatingSupplier = new RotatingFileOutputStreamSupplier(fileSystem, logFile, ((Long)config.get(SecuritySettings.store_security_log_rotation_threshold)).longValue(), ((Long)config.get(SecuritySettings.store_security_log_rotation_delay)).longValue(), ((Integer)config.get(SecuritySettings.store_security_log_max_archives)).intValue(), executor);
        FormattedLog formattedLog = builder.toOutputStream((Supplier)this.rotatingSupplier);
        formattedLog.setLevel((Level)config.get(SecuritySettings.security_log_level));
        this.inner = new AsyncLog(event -> executor.execute(() -> ((AsyncLogEvent)event).process()), (Log)formattedLog);
    }

    public SecurityLog(Log log) {
        this.inner = log;
    }

    private static String withSubject(AuthSubject subject, String msg) {
        return "[" + Strings.escape((String)subject.username()) + "]: " + msg;
    }

    public boolean isDebugEnabled() {
        return this.inner.isDebugEnabled();
    }

    public Logger debugLogger() {
        return this.inner.debugLogger();
    }

    public void debug(String message) {
        this.inner.debug(message);
    }

    public void debug(String message, Throwable throwable) {
        this.inner.debug(message, throwable);
    }

    public void debug(String format, Object ... arguments) {
        this.inner.debug(format, arguments);
    }

    public void debug(AuthSubject subject, String format, Object ... arguments) {
        this.inner.debug(SecurityLog.withSubject(subject, format), arguments);
    }

    public Logger infoLogger() {
        return this.inner.infoLogger();
    }

    public void info(String message) {
        this.inner.info(message);
    }

    public void info(String message, Throwable throwable) {
        this.inner.info(message, throwable);
    }

    public void info(String format, Object ... arguments) {
        this.inner.info(format, arguments);
    }

    public void info(AuthSubject subject, String format, Object ... arguments) {
        this.inner.info(SecurityLog.withSubject(subject, format), arguments);
    }

    public void info(AuthSubject subject, String format) {
        this.inner.info(SecurityLog.withSubject(subject, format));
    }

    public Logger warnLogger() {
        return this.inner.warnLogger();
    }

    public void warn(String message) {
        this.inner.warn(message);
    }

    public void warn(String message, Throwable throwable) {
        this.inner.warn(message, throwable);
    }

    public void warn(String format, Object ... arguments) {
        this.inner.warn(format, arguments);
    }

    public void warn(AuthSubject subject, String format, Object ... arguments) {
        this.inner.warn(SecurityLog.withSubject(subject, format), arguments);
    }

    public Logger errorLogger() {
        return this.inner.errorLogger();
    }

    public void error(String message) {
        this.inner.error(message);
    }

    public void error(String message, Throwable throwable) {
        this.inner.error(message, throwable);
    }

    public void error(String format, Object ... arguments) {
        this.inner.error(format, arguments);
    }

    public void error(AuthSubject subject, String format, Object ... arguments) {
        this.inner.error(SecurityLog.withSubject(subject, format), arguments);
    }

    public void bulk(Consumer<Log> consumer) {
        this.inner.bulk(consumer);
    }

    public static SecurityLog create(Config config, Log log, FileSystemAbstraction fileSystem, JobScheduler jobScheduler) {
        try {
            return new SecurityLog(config, fileSystem, jobScheduler.executor(JobScheduler.Groups.internalLogRotation));
        }
        catch (IOException ioe) {
            log.warn("Unable to create log for auth-manager. Auth logging turned off.");
            return null;
        }
    }

    public void shutdown() throws Throwable {
        if (this.rotatingSupplier != null) {
            this.rotatingSupplier.close();
            this.rotatingSupplier = null;
        }
    }
}

