/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth.plugin;

import java.io.File;
import java.nio.file.Path;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.api.security.exception.InvalidAuthTokenException;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.internal.Version;
import org.neo4j.logging.Log;
import org.neo4j.server.security.enterprise.auth.PredefinedRolesBuilder;
import org.neo4j.server.security.enterprise.auth.RealmLifecycle;
import org.neo4j.server.security.enterprise.auth.SecureHasher;
import org.neo4j.server.security.enterprise.auth.ShiroAuthToken;
import org.neo4j.server.security.enterprise.auth.ShiroAuthorizationInfoProvider;
import org.neo4j.server.security.enterprise.auth.plugin.CustomCredentialsMatcherSupplier;
import org.neo4j.server.security.enterprise.auth.plugin.PluginApiAuthToken;
import org.neo4j.server.security.enterprise.auth.plugin.PluginAuthInfo;
import org.neo4j.server.security.enterprise.auth.plugin.PluginAuthenticationInfo;
import org.neo4j.server.security.enterprise.auth.plugin.PluginAuthorizationInfo;
import org.neo4j.server.security.enterprise.auth.plugin.PluginShiroAuthToken;
import org.neo4j.server.security.enterprise.auth.plugin.api.AuthProviderOperations;
import org.neo4j.server.security.enterprise.auth.plugin.api.AuthToken;
import org.neo4j.server.security.enterprise.auth.plugin.api.AuthenticationException;
import org.neo4j.server.security.enterprise.auth.plugin.api.AuthorizationExpiredException;
import org.neo4j.server.security.enterprise.auth.plugin.spi.AuthInfo;
import org.neo4j.server.security.enterprise.auth.plugin.spi.AuthPlugin;
import org.neo4j.server.security.enterprise.auth.plugin.spi.AuthenticationInfo;
import org.neo4j.server.security.enterprise.auth.plugin.spi.AuthenticationPlugin;
import org.neo4j.server.security.enterprise.auth.plugin.spi.AuthorizationInfo;
import org.neo4j.server.security.enterprise.auth.plugin.spi.AuthorizationPlugin;
import org.neo4j.server.security.enterprise.auth.plugin.spi.CustomCacheableAuthenticationInfo;
import org.neo4j.server.security.enterprise.log.SecurityLog;

public class PluginRealm
extends AuthorizingRealm
implements RealmLifecycle,
ShiroAuthorizationInfoProvider {
    private AuthenticationPlugin authenticationPlugin;
    private AuthorizationPlugin authorizationPlugin;
    private final Config config;
    private AuthPlugin authPlugin;
    private final Log log;
    private final Clock clock;
    private final SecureHasher secureHasher;
    private AuthProviderOperations authProviderOperations = new PluginRealmOperations();

    public PluginRealm(Config config, SecurityLog securityLog, Clock clock, SecureHasher secureHasher) {
        this.config = config;
        this.clock = clock;
        this.secureHasher = secureHasher;
        this.log = securityLog;
        this.setCredentialsMatcher(new CredentialsMatcher());
        this.setAuthenticationCachingEnabled(false);
        this.setAuthorizationCachingEnabled(true);
        this.setRolePermissionResolver(PredefinedRolesBuilder.rolePermissionResolver);
    }

    public PluginRealm(AuthenticationPlugin authenticationPlugin, AuthorizationPlugin authorizationPlugin, Config config, SecurityLog securityLog, Clock clock, SecureHasher secureHasher) {
        this(config, securityLog, clock, secureHasher);
        this.authenticationPlugin = authenticationPlugin;
        this.authorizationPlugin = authorizationPlugin;
        this.resolvePluginName();
    }

    public PluginRealm(AuthPlugin authPlugin, Config config, SecurityLog securityLog, Clock clock, SecureHasher secureHasher) {
        this(config, securityLog, clock, secureHasher);
        this.authPlugin = authPlugin;
        this.resolvePluginName();
    }

    private void resolvePluginName() {
        String pluginName = null;
        if (this.authPlugin != null) {
            pluginName = this.authPlugin.name();
        } else if (this.authenticationPlugin != null) {
            pluginName = this.authenticationPlugin.name();
        } else if (this.authorizationPlugin != null) {
            pluginName = this.authorizationPlugin.name();
        }
        if (pluginName != null && !pluginName.isEmpty()) {
            this.setName("plugin-" + pluginName);
        }
    }

    private Collection<AuthorizationPlugin.PrincipalAndProvider> getPrincipalAndProviderCollection(PrincipalCollection principalCollection) {
        ArrayList<AuthorizationPlugin.PrincipalAndProvider> principalAndProviderCollection = new ArrayList<AuthorizationPlugin.PrincipalAndProvider>();
        for (String realm : principalCollection.getRealmNames()) {
            for (Object principal : principalCollection.fromRealm(realm)) {
                principalAndProviderCollection.add(new AuthorizationPlugin.PrincipalAndProvider(principal, realm));
            }
        }
        return principalAndProviderCollection;
    }

    protected org.apache.shiro.authz.AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        if (this.authorizationPlugin != null) {
            AuthorizationInfo authorizationInfo;
            try {
                authorizationInfo = this.authorizationPlugin.authorize(this.getPrincipalAndProviderCollection(principals));
            }
            catch (AuthorizationExpiredException e) {
                throw new org.neo4j.graphdb.security.AuthorizationExpiredException("Plugin '" + this.getName() + "' authorization info expired: " + e.getMessage(), (Throwable)e);
            }
            if (authorizationInfo != null) {
                return PluginAuthorizationInfo.create(authorizationInfo);
            }
        } else if (this.authPlugin != null && !principals.fromRealm(this.getName()).isEmpty()) {
            throw new org.neo4j.graphdb.security.AuthorizationExpiredException("Plugin '" + this.getName() + "' authorization info expired.");
        }
        return null;
    }

    protected org.apache.shiro.authc.AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws org.apache.shiro.authc.AuthenticationException {
        if (token instanceof ShiroAuthToken) {
            try {
                AuthenticationInfo authenticationInfo;
                AuthToken pluginAuthToken = PluginApiAuthToken.createFromMap(((ShiroAuthToken)token).getAuthTokenMap());
                if (this.authPlugin != null) {
                    AuthInfo authInfo = this.authPlugin.authenticateAndAuthorize(pluginAuthToken);
                    if (authInfo != null) {
                        PluginAuthInfo pluginAuthInfo = PluginAuthInfo.createCacheable(authInfo, this.getName(), this.secureHasher);
                        this.cacheAuthorizationInfo(pluginAuthInfo);
                        return pluginAuthInfo;
                    }
                } else if (this.authenticationPlugin != null && (authenticationInfo = this.authenticationPlugin.authenticate(pluginAuthToken)) != null) {
                    return PluginAuthenticationInfo.createCacheable(authenticationInfo, this.getName(), this.secureHasher);
                }
            }
            catch (InvalidAuthTokenException | AuthenticationException e) {
                throw new org.apache.shiro.authc.AuthenticationException(e.getMessage(), e.getCause());
            }
        }
        return null;
    }

    private void cacheAuthorizationInfo(PluginAuthInfo authInfo) {
        Cache authorizationCache = this.getAuthorizationCache();
        Object key = this.getAuthorizationCacheKey(authInfo.getPrincipals());
        authorizationCache.put(key, (Object)authInfo);
    }

    public boolean canAuthenticate() {
        return this.authPlugin != null || this.authenticationPlugin != null;
    }

    public boolean canAuthorize() {
        return this.authPlugin != null || this.authorizationPlugin != null;
    }

    @Override
    public org.apache.shiro.authz.AuthorizationInfo getAuthorizationInfoSnapshot(PrincipalCollection principalCollection) {
        return this.getAuthorizationInfo(principalCollection);
    }

    protected Object getAuthorizationCacheKey(PrincipalCollection principals) {
        return this.getAvailablePrincipal(principals);
    }

    protected Object getAuthenticationCacheKey(AuthenticationToken token) {
        return token != null ? token.getPrincipal() : null;
    }

    public boolean supports(AuthenticationToken token) {
        return this.supportsSchemeAndRealm(token);
    }

    private boolean supportsSchemeAndRealm(AuthenticationToken token) {
        if (token instanceof ShiroAuthToken) {
            ShiroAuthToken shiroAuthToken = (ShiroAuthToken)token;
            return shiroAuthToken.supportsRealm(this.getName());
        }
        return false;
    }

    @Override
    public void initialize() throws Throwable {
        if (this.authenticationPlugin != null) {
            this.authenticationPlugin.initialize(this.authProviderOperations);
        }
        if (this.authorizationPlugin != null && this.authorizationPlugin != this.authenticationPlugin) {
            this.authorizationPlugin.initialize(this.authProviderOperations);
        }
        if (this.authPlugin != null) {
            this.authPlugin.initialize(this.authProviderOperations);
        }
    }

    @Override
    public void start() throws Throwable {
        if (this.authenticationPlugin != null) {
            this.authenticationPlugin.start();
        }
        if (this.authorizationPlugin != null && this.authorizationPlugin != this.authenticationPlugin) {
            this.authorizationPlugin.start();
        }
        if (this.authPlugin != null) {
            this.authPlugin.start();
        }
    }

    @Override
    public void stop() throws Throwable {
        if (this.authenticationPlugin != null) {
            this.authenticationPlugin.stop();
        }
        if (this.authorizationPlugin != null && this.authorizationPlugin != this.authenticationPlugin) {
            this.authorizationPlugin.stop();
        }
        if (this.authPlugin != null) {
            this.authPlugin.stop();
        }
    }

    @Override
    public void shutdown() throws Throwable {
        if (this.authenticationPlugin != null) {
            this.authenticationPlugin.shutdown();
        }
        if (this.authorizationPlugin != null && this.authorizationPlugin != this.authenticationPlugin) {
            this.authorizationPlugin.shutdown();
        }
        if (this.authPlugin != null) {
            this.authPlugin.shutdown();
        }
    }

    private static CustomCacheableAuthenticationInfo.CredentialsMatcher getCustomCredentialsMatcherIfPresent(org.apache.shiro.authc.AuthenticationInfo info) {
        if (info instanceof CustomCredentialsMatcherSupplier) {
            return ((CustomCredentialsMatcherSupplier)info).getCredentialsMatcher();
        }
        return null;
    }

    private class PluginRealmOperations
    implements AuthProviderOperations {
        private AuthProviderOperations.Log innerLog = new AuthProviderOperations.Log(){

            private String withPluginName(String msg) {
                return "{" + PluginRealm.this.getName() + "} " + msg;
            }

            public void debug(String message) {
                PluginRealm.this.log.debug(this.withPluginName(message));
            }

            public void info(String message) {
                PluginRealm.this.log.info(this.withPluginName(message));
            }

            public void warn(String message) {
                PluginRealm.this.log.warn(this.withPluginName(message));
            }

            public void error(String message) {
                PluginRealm.this.log.error(this.withPluginName(message));
            }

            public boolean isDebugEnabled() {
                return PluginRealm.this.log.isDebugEnabled();
            }
        };

        private PluginRealmOperations() {
        }

        public Path neo4jHome() {
            return ((File)PluginRealm.this.config.get(GraphDatabaseSettings.neo4j_home)).getAbsoluteFile().toPath();
        }

        public Optional<Path> neo4jConfigFile() {
            return PluginRealm.this.config.getConfigFile();
        }

        public String neo4jVersion() {
            return Version.getNeo4jVersion();
        }

        public Clock clock() {
            return PluginRealm.this.clock;
        }

        public AuthProviderOperations.Log log() {
            return this.innerLog;
        }

        public void setAuthenticationCachingEnabled(boolean authenticationCachingEnabled) {
            PluginRealm.this.setAuthenticationCachingEnabled(authenticationCachingEnabled);
        }

        public void setAuthorizationCachingEnabled(boolean authorizationCachingEnabled) {
            PluginRealm.this.setAuthorizationCachingEnabled(authorizationCachingEnabled);
        }
    }

    private class CredentialsMatcher
    implements org.apache.shiro.authc.credential.CredentialsMatcher {
        private CredentialsMatcher() {
        }

        public boolean doCredentialsMatch(AuthenticationToken token, org.apache.shiro.authc.AuthenticationInfo info) {
            CustomCacheableAuthenticationInfo.CredentialsMatcher customCredentialsMatcher = PluginRealm.getCustomCredentialsMatcherIfPresent(info);
            if (customCredentialsMatcher != null) {
                Map<String, Object> authToken = ((ShiroAuthToken)token).getAuthTokenMap();
                try {
                    AuthToken pluginApiAuthToken = PluginApiAuthToken.createFromMap(authToken);
                    return customCredentialsMatcher.doCredentialsMatch(pluginApiAuthToken);
                }
                catch (InvalidAuthTokenException e) {
                    throw new org.apache.shiro.authc.AuthenticationException(e.getMessage());
                }
            }
            if (info.getCredentials() != null) {
                return PluginRealm.this.secureHasher.getHashedCredentialsMatcher().doCredentialsMatch((AuthenticationToken)PluginShiroAuthToken.of(token), info);
            }
            if (PluginRealm.this.isAuthenticationCachingEnabled()) {
                PluginRealm.this.log.error("Authentication caching is enabled in plugin %s but it does not return cacheable credentials. This configuration is not secure.", new Object[]{PluginRealm.this.getName()});
                return false;
            }
            return true;
        }
    }
}

