/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Ticker;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import org.apache.shiro.cache.CacheException;
import org.apache.shiro.cache.CacheManager;

class ShiroCaffeineCache<K, V>
implements org.apache.shiro.cache.Cache<K, V> {
    private final Cache<K, V> caffCache;

    ShiroCaffeineCache(Ticker ticker, long ttl, int maxCapacity) {
        this(ticker, ForkJoinPool.commonPool(), ttl, maxCapacity);
    }

    ShiroCaffeineCache(Ticker ticker, Executor maintenanceExecutor, long ttl, int maxCapacity) {
        if (ttl <= 0L) {
            throw new IllegalArgumentException("TTL must be larger than zero.");
        }
        this.caffCache = Caffeine.newBuilder().maximumSize((long)maxCapacity).expireAfterWrite(ttl, TimeUnit.MILLISECONDS).executor(maintenanceExecutor).ticker(ticker).build();
    }

    public V get(K key) throws CacheException {
        return (V)this.caffCache.getIfPresent(key);
    }

    public V put(K key, V value) throws CacheException {
        return this.caffCache.asMap().put(key, value);
    }

    public V remove(K key) throws CacheException {
        return this.caffCache.asMap().remove(key);
    }

    public void clear() throws CacheException {
        this.caffCache.invalidateAll();
    }

    public int size() {
        return this.caffCache.asMap().size();
    }

    public Set<K> keys() {
        return this.caffCache.asMap().keySet();
    }

    public Collection<V> values() {
        return this.caffCache.asMap().values();
    }

    private static class NullCache<K, V>
    implements org.apache.shiro.cache.Cache<K, V> {
        private NullCache() {
        }

        public V get(K key) throws CacheException {
            return null;
        }

        public V put(K key, V value) throws CacheException {
            return null;
        }

        public V remove(K key) throws CacheException {
            return null;
        }

        public void clear() throws CacheException {
        }

        public int size() {
            return 0;
        }

        public Set<K> keys() {
            return Collections.emptySet();
        }

        public Collection<V> values() {
            return Collections.emptySet();
        }
    }

    static class Manager
    implements CacheManager {
        private final Map<String, org.apache.shiro.cache.Cache<?, ?>> caches;
        private final Ticker ticker;
        private final long ttl;
        private final int maxCapacity;

        Manager(Ticker ticker, long ttl, int maxCapacity) {
            this.ticker = ticker;
            this.ttl = ttl;
            this.maxCapacity = maxCapacity;
            this.caches = new HashMap();
        }

        public <K, V> org.apache.shiro.cache.Cache<K, V> getCache(String s) throws CacheException {
            return this.caches.computeIfAbsent(s, ignored -> this.ttl <= 0L ? new NullCache() : new ShiroCaffeineCache(this.ticker, this.ttl, this.maxCapacity));
        }
    }
}

