/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth;

import java.io.IOException;
import java.util.stream.Stream;
import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.enterprise.api.security.EnterpriseAuthManager;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Procedure;
import org.neo4j.server.security.enterprise.auth.AuthProceduresBase;

public class SecurityProcedures
extends AuthProceduresBase {
    @Context
    public EnterpriseAuthManager authManager;

    @Description(value="Show the current user.")
    @Procedure(name="dbms.security.showCurrentUser", mode=Mode.DBMS)
    public Stream<AuthProceduresBase.UserResult> showCurrentUser() throws InvalidArgumentsException, IOException {
        return Stream.of(this.userResultForSubject());
    }

    @Description(value="Clears authentication and authorization cache.")
    @Procedure(name="dbms.security.clearAuthCache", mode=Mode.DBMS)
    public void clearAuthenticationCache() {
        if (!this.securityContext.isAdmin()) {
            throw new AuthorizationViolationException("Permission denied.");
        }
        this.authManager.clearAuthCache();
    }
}

