/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.authz.SimpleRole;
import org.apache.shiro.authz.permission.RolePermissionResolver;
import org.apache.shiro.authz.permission.WildcardPermission;
import org.neo4j.server.security.enterprise.auth.RolesBuilder;

public class PredefinedRolesBuilder
implements RolesBuilder {
    private static final WildcardPermission SCHEMA = new WildcardPermission("schema:*");
    private static final WildcardPermission FULL = new WildcardPermission("*");
    private static final WildcardPermission TOKEN = new WildcardPermission("token:*");
    private static final WildcardPermission WRITE = new WildcardPermission("data:*");
    private static final WildcardPermission READ = new WildcardPermission("data:read");
    private static final Map<String, SimpleRole> innerRoles = PredefinedRolesBuilder.staticBuildRoles();
    public static final Map<String, SimpleRole> roles = Collections.unmodifiableMap(innerRoles);
    public static final RolePermissionResolver rolePermissionResolver = new RolePermissionResolver(){

        public Collection<Permission> resolvePermissionsInRole(String roleString) {
            if (roleString == null) {
                return Collections.emptyList();
            }
            SimpleRole role = roles.get(roleString);
            if (role != null) {
                return role.getPermissions();
            }
            return Collections.emptyList();
        }
    };

    private static Map<String, SimpleRole> staticBuildRoles() {
        ConcurrentHashMap<String, SimpleRole> roles = new ConcurrentHashMap<String, SimpleRole>(4);
        SimpleRole admin = new SimpleRole("admin");
        admin.add((Permission)FULL);
        roles.put("admin", admin);
        SimpleRole architect = new SimpleRole("architect");
        architect.add((Permission)SCHEMA);
        architect.add((Permission)WRITE);
        architect.add((Permission)TOKEN);
        roles.put("architect", architect);
        SimpleRole publisher = new SimpleRole("publisher");
        publisher.add((Permission)WRITE);
        publisher.add((Permission)TOKEN);
        roles.put("publisher", publisher);
        SimpleRole reader = new SimpleRole("reader");
        reader.add((Permission)READ);
        roles.put("reader", reader);
        return roles;
    }

    @Override
    public Map<String, SimpleRole> buildRoles() {
        return roles;
    }
}

