/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.schema.constraints;

import java.util.Arrays;
import java.util.StringJoiner;
import java.util.TreeSet;
import org.neo4j.internal.schema.SchemaValueType;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueRepresentation;

public class PropertyTypeSet
extends TreeSet<SchemaValueType> {
    public String userDescription() {
        StringJoiner joiner = this.size() > 1 ? new StringJoiner(" | ", "ANY<", ">") : new StringJoiner("");
        this.forEach(schemaValueType -> joiner.add(schemaValueType.userDescription()));
        return joiner.toString();
    }

    public static PropertyTypeSet of(SchemaValueType ... types) {
        PropertyTypeSet set = new PropertyTypeSet();
        set.addAll(Arrays.asList(types));
        return set;
    }

    public boolean valueIsOfTypes(Value value) {
        ValueRepresentation valueRepresentation = value.valueRepresentation();
        for (SchemaValueType valueType : this) {
            if (!valueType.isAssignable(valueRepresentation)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.stream().mapToInt(type -> type.serialize().hashCode()).sum();
    }
}

