/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.schema;

import java.util.List;
import java.util.StringJoiner;
import java.util.function.IntFunction;
import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.schema.ConstraintType;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaValueType;
import org.neo4j.token.api.TokenIdPrettyPrinter;

public final class SchemaUserDescription {
    public static final String TOKEN_LABEL = "<any-labels>";
    public static final String TOKEN_REL_TYPE = "<any-types>";
    public static final TokenNameLookup TOKEN_ID_NAME_LOOKUP = new TokenNameLookup(){

        public String labelGetName(int labelId) {
            return "Label[" + labelId + "]";
        }

        public String relationshipTypeGetName(int relationshipTypeId) {
            return "RelationshipType[" + relationshipTypeId + "]";
        }

        public String propertyKeyGetName(int propertyKeyId) {
            return "PropertyKey[" + propertyKeyId + "]";
        }
    };

    private SchemaUserDescription() {
    }

    static String forSchema(TokenNameLookup tokenNameLookup, EntityType entityType, int[] entityTokens, int[] propertyKeyIds) {
        String suffix;
        String prefix = entityType == EntityType.RELATIONSHIP ? "()-[" : "(";
        String string = suffix = entityType == EntityType.RELATIONSHIP ? "]-()" : ")";
        if (entityTokens.length == 0 && propertyKeyIds.length == 0) {
            String entityTokenType = ":" + (entityType == EntityType.RELATIONSHIP ? TOKEN_REL_TYPE : TOKEN_LABEL);
            return prefix + entityTokenType + suffix;
        }
        IntFunction<String> lookup = entityType == EntityType.NODE ? arg_0 -> ((TokenNameLookup)tokenNameLookup).labelGetName(arg_0) : arg_0 -> ((TokenNameLookup)tokenNameLookup).relationshipTypeGetName(arg_0);
        return prefix + TokenIdPrettyPrinter.niceEntityLabels(lookup, (int[])entityTokens) + " " + TokenIdPrettyPrinter.niceProperties((TokenNameLookup)tokenNameLookup, (int[])propertyKeyIds, (char)'{', (char)'}') + suffix;
    }

    static String forPrototype(TokenNameLookup tokenNameLookup, String name, String indexType, SchemaDescriptor schema, IndexProviderDescriptor indexProvider) {
        StringJoiner joiner = new StringJoiner(", ", "Index( ", " )");
        SchemaUserDescription.addPrototypeParams(tokenNameLookup, name, indexType, schema, indexProvider, joiner);
        return joiner.toString();
    }

    public static String forIndex(TokenNameLookup tokenNameLookup, long id, String name, String indexType, SchemaDescriptor schema, IndexProviderDescriptor indexProvider, Long owningConstraintId) {
        StringJoiner joiner = new StringJoiner(", ", "Index( ", " )");
        joiner.add("id=" + id);
        SchemaUserDescription.addPrototypeParams(tokenNameLookup, name, indexType, schema, indexProvider, joiner);
        if (owningConstraintId != null) {
            joiner.add("owningConstraint=" + owningConstraintId);
        }
        return joiner.toString();
    }

    public static String forConstraint(TokenNameLookup tokenNameLookup, long id, String name, ConstraintType type, SchemaDescriptor schema, Long ownedIndex, List<SchemaValueType> allowedPropertyTypes) {
        StringJoiner joiner = new StringJoiner(", ", "Constraint( ", " )");
        SchemaUserDescription.maybeAddId(id, joiner);
        SchemaUserDescription.maybeAddName(name, joiner);
        SchemaUserDescription.addType(SchemaUserDescription.constraintType(type, schema.entityType()), joiner);
        SchemaUserDescription.addSchema(tokenNameLookup, schema, joiner);
        if (ownedIndex != null) {
            joiner.add("ownedIndex=" + ownedIndex);
        }
        SchemaUserDescription.maybeAddAllowedPropertyTypes(allowedPropertyTypes, joiner);
        return joiner.toString();
    }

    private static String constraintType(ConstraintType type, EntityType entityType) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case ConstraintType.EXISTS -> entityType.name() + " PROPERTY EXISTENCE";
            case ConstraintType.UNIQUE -> {
                if (entityType == EntityType.NODE) {
                    yield "UNIQUENESS";
                }
                yield entityType.name() + " UNIQUENESS";
            }
            case ConstraintType.UNIQUE_EXISTS -> entityType.name() + " KEY";
            case ConstraintType.PROPERTY_TYPE -> entityType.name() + " PROPERTY TYPE";
        };
    }

    private static void maybeAddId(long id, StringJoiner joiner) {
        if (id != -1L) {
            joiner.add("id=" + id);
        }
    }

    private static void maybeAddName(String name, StringJoiner joiner) {
        if (name != null) {
            joiner.add("name='" + name + "'");
        }
    }

    private static void maybeAddAllowedPropertyTypes(List<SchemaValueType> allowedPropertyTypes, StringJoiner joiner) {
        if (allowedPropertyTypes != null) {
            joiner.add("allowedPropertyTypes='" + allowedPropertyTypes + "'");
        }
    }

    private static void addPrototypeParams(TokenNameLookup tokenNameLookup, String name, String indexType, SchemaDescriptor schema, IndexProviderDescriptor indexProvider, StringJoiner joiner) {
        SchemaUserDescription.maybeAddName(name, joiner);
        SchemaUserDescription.addType(indexType, joiner);
        SchemaUserDescription.addSchema(tokenNameLookup, schema, joiner);
        joiner.add("indexProvider='" + indexProvider.name() + "'");
    }

    private static void addType(String type, StringJoiner joiner) {
        joiner.add("type='" + type + "'");
    }

    private static void addSchema(TokenNameLookup tokenNameLookup, SchemaDescriptor schema, StringJoiner joiner) {
        joiner.add("schema=" + schema.userDescription(tokenNameLookup));
    }
}

