/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.schema;

import java.util.Map;
import org.neo4j.internal.schema.SchemaScalarValueType;
import org.neo4j.internal.schema.SchemaValueType;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueRepresentation;

public record SchemaListValueType(UserFacingType userFacingType, SchemaScalarValueType contentType) implements SchemaValueType
{
    private static final Map<ValueRepresentation, ValueRepresentation> ARRAY_TO_SCALAR_MAPPING = Map.of(ValueRepresentation.BOOLEAN_ARRAY, ValueRepresentation.BOOLEAN, ValueRepresentation.INT64_ARRAY, ValueRepresentation.INT64);

    @Override
    public boolean isAssignable(Value value) {
        if (value instanceof ArrayValue) {
            ArrayValue arrayValue = (ArrayValue)value;
            ValueRepresentation scalarValue = ARRAY_TO_SCALAR_MAPPING.get(arrayValue.valueRepresentation());
            if (scalarValue == null) {
                throw new IllegalStateException("Unrecognized array value " + arrayValue.valueRepresentation());
            }
            return this.contentType.isAssignable(scalarValue);
        }
        return false;
    }

    static enum UserFacingType {
        LIST,
        ARRAY;

    }
}

