/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.exceptions.schema;

import org.neo4j.common.TokenNameLookup;
import org.neo4j.exceptions.KernelException;
import org.neo4j.gqlstatus.ErrorClassification;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlClassification;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.exceptions.Status;

public class IndexNotFoundKernelException
extends KernelException {
    private final IndexDescriptor index;

    public IndexNotFoundKernelException(String msg) {
        super((Status)Status.Schema.IndexNotFound, msg, new Object[0]);
        this.index = null;
    }

    private IndexNotFoundKernelException(ErrorGqlStatusObject gqlStatusObject, String msg) {
        super(gqlStatusObject, (Status)Status.Schema.IndexNotFound, msg, new Object[0]);
        this.index = null;
    }

    public IndexNotFoundKernelException(String msg, IndexDescriptor index) {
        super((Status)Status.Schema.IndexNotFound, msg, new Object[0]);
        this.index = index;
    }

    private IndexNotFoundKernelException(ErrorGqlStatusObject gqlStatusObject, String msg, IndexDescriptor index) {
        super(gqlStatusObject, (Status)Status.Schema.IndexNotFound, msg, new Object[0]);
        this.index = index;
    }

    public static IndexNotFoundKernelException indexIsStillPopulating(String indexPopulationJobDescription) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N63).withClassification((GqlClassification)ErrorClassification.TRANSIENT_ERROR).build();
        return new IndexNotFoundKernelException(gql, "Index is still populating: " + indexPopulationJobDescription);
    }

    public static IndexNotFoundKernelException indexIsStillPopulating(IndexDescriptor descriptor) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N63).withClassification((GqlClassification)ErrorClassification.TRANSIENT_ERROR).build();
        return new IndexNotFoundKernelException(gql, descriptor + " is still populating");
    }

    public static IndexNotFoundKernelException indexDroppedWhileSampling() {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N64).withClassification((GqlClassification)ErrorClassification.CLIENT_ERROR).build();
        return new IndexNotFoundKernelException(gql, "Index dropped while sampling.");
    }

    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        if (this.index == null) {
            return super.getUserMessage(tokenNameLookup);
        }
        return super.getUserMessage(tokenNameLookup) + this.index.userDescription(tokenNameLookup);
    }
}

