/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.exceptions.schema;

import org.neo4j.common.TokenNameLookup;
import org.neo4j.exceptions.KernelException;
import org.neo4j.gqlstatus.ErrorClassification;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlClassification;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.kernel.api.exceptions.Status;

public class CreateConstraintFailureException
extends SchemaKernelException {
    private final ConstraintDescriptor constraint;
    private final String cause;

    @Deprecated
    public CreateConstraintFailureException(ConstraintDescriptor constraint, Throwable cause) {
        super((Status)Status.Schema.ConstraintCreationFailed, cause, "Unable to create constraint %s: %s", constraint, cause.getMessage());
        this.constraint = constraint;
        this.cause = null;
    }

    public CreateConstraintFailureException(ErrorGqlStatusObject gqlStatusObject, ConstraintDescriptor constraint, Throwable cause) {
        super(gqlStatusObject, (Status)Status.Schema.ConstraintCreationFailed, cause, "Unable to create constraint %s: %s", constraint, cause.getMessage());
        this.constraint = constraint;
        this.cause = null;
    }

    public static CreateConstraintFailureException constraintCreationFailed(ConstraintValidationException cause, TokenNameLookup tokenNameLookup) {
        return CreateConstraintFailureException.constraintCreationFailed(cause.constraint, tokenNameLookup, cause.gqlStatusObject(), (Throwable)((Object)cause));
    }

    public static CreateConstraintFailureException constraintCreationFailed(ConstraintDescriptor constraint, TokenNameLookup tokenNameLookup, ErrorGqlStatusObject gqlCause, Throwable cause) {
        String constraintString = constraint.userDescription(tokenNameLookup);
        return CreateConstraintFailureException.constraintCreationFailed(constraint, constraintString, gqlCause, cause);
    }

    public static CreateConstraintFailureException constraintCreationFailed(ConstraintDescriptor constraint, String constraintString, ErrorGqlStatusObject gqlCause, Throwable cause) {
        ErrorGqlStatusObjectImplementation.Builder errorGqlStatusObjectBuilder = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_50N11).withClassification((GqlClassification)ErrorClassification.CLIENT_ERROR).withParam(GqlParams.StringParam.constrDescrOrName, constraint.getName() != null ? constraint.getName() : constraintString);
        if (gqlCause != null) {
            errorGqlStatusObjectBuilder.withCause(gqlCause);
        }
        return new CreateConstraintFailureException(errorGqlStatusObjectBuilder.build(), constraint, cause);
    }

    public CreateConstraintFailureException(ConstraintDescriptor constraint, String cause) {
        super((Status)Status.Schema.ConstraintCreationFailed, null, "Unable to create constraint %s: %s", constraint, cause);
        this.constraint = constraint;
        this.cause = cause;
    }

    public CreateConstraintFailureException(ErrorGqlStatusObject gqlStatusObject, ConstraintDescriptor constraint, String cause) {
        super(gqlStatusObject, (Status)Status.Schema.ConstraintCreationFailed, null, "Unable to create constraint %s: %s", constraint, cause);
        this.constraint = constraint;
        this.cause = cause;
    }

    public ConstraintDescriptor constraint() {
        return this.constraint;
    }

    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        StringBuilder sb = new StringBuilder("Unable to create ").append(this.constraint.userDescription(tokenNameLookup));
        Throwable throwable = this.getCause();
        if (throwable instanceof KernelException) {
            KernelException kernelCause = (KernelException)throwable;
            sb.append(':').append(System.lineSeparator()).append(kernelCause.getUserMessage(tokenNameLookup));
        } else if (this.cause != null) {
            sb.append(':').append(System.lineSeparator()).append(this.cause);
        }
        return sb.append(". Note that only the first found violation is shown.").toString();
    }
}

