/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.schema.constraints;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Stream;
import org.neo4j.internal.schema.constraints.SchemaValueType;
import org.neo4j.internal.schema.constraints.SpecialTypes;
import org.neo4j.internal.schema.constraints.TypeRepresentation;

public class PropertyTypeSet
implements Iterable<SchemaValueType> {
    private final Set<SchemaValueType> lookup;
    private final List<SchemaValueType> types;
    private final boolean acceptsEmptyList;

    private PropertyTypeSet(Set<SchemaValueType> lookup, List<SchemaValueType> types, boolean acceptsEmptyList) {
        this.lookup = lookup;
        this.types = types;
        this.acceptsEmptyList = acceptsEmptyList;
    }

    public static PropertyTypeSet empty() {
        return new PropertyTypeSet(Set.of(), List.of(), false);
    }

    public static PropertyTypeSet of(Collection<SchemaValueType> types) {
        if (types.isEmpty()) {
            return PropertyTypeSet.empty();
        }
        EnumSet<SchemaValueType> lookup = EnumSet.copyOf(types);
        List<SchemaValueType> uniqueTypes = lookup.stream().sorted(TypeRepresentation::compare).toList();
        boolean acceptsEmptyList = types.stream().anyMatch(TypeRepresentation::isList);
        return new PropertyTypeSet(lookup, uniqueTypes, acceptsEmptyList);
    }

    public static PropertyTypeSet of(SchemaValueType ... types) {
        return PropertyTypeSet.of(Arrays.asList(types));
    }

    public String userDescription() {
        if (this.types.isEmpty()) {
            return "NOTHING";
        }
        StringJoiner joiner = new StringJoiner(" | ");
        for (SchemaValueType type : this.types) {
            joiner.add(type.userDescription());
        }
        return joiner.toString();
    }

    public int hashCode() {
        return this.types.stream().mapToInt(type -> type.serialize().hashCode()).sum();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyTypeSet that = (PropertyTypeSet)o;
        return this.types.equals(that.types);
    }

    public int size() {
        return this.types.size();
    }

    public boolean contains(TypeRepresentation repr) {
        if (repr instanceof SchemaValueType) {
            SchemaValueType type = (SchemaValueType)repr;
            return this.lookup.contains(type);
        }
        if (repr == SpecialTypes.NULL) {
            return true;
        }
        return this.acceptsEmptyList && repr == SpecialTypes.LIST_NOTHING;
    }

    public PropertyTypeSet union(PropertyTypeSet other) {
        return PropertyTypeSet.of(Stream.concat(this.stream(), other.stream()).toList());
    }

    public PropertyTypeSet intersection(PropertyTypeSet other) {
        return PropertyTypeSet.of(this.stream().filter(other.lookup::contains).toList());
    }

    public PropertyTypeSet difference(PropertyTypeSet other) {
        return PropertyTypeSet.of(this.stream().filter(v -> !other.lookup.contains(v)).toList());
    }

    public Stream<SchemaValueType> stream() {
        return this.types.stream();
    }

    @Override
    public Iterator<SchemaValueType> iterator() {
        return this.types.iterator();
    }

    public SchemaValueType[] values() {
        return (SchemaValueType[])this.types.toArray(SchemaValueType[]::new);
    }
}

