/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.schema.constraints;

import org.neo4j.internal.schema.EndpointType;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.internal.schema.constraints.ConstraintDescriptorImplementation;
import org.neo4j.internal.schema.constraints.ExistenceConstraintDescriptor;
import org.neo4j.internal.schema.constraints.KeyConstraintDescriptor;
import org.neo4j.internal.schema.constraints.PropertyTypeSet;
import org.neo4j.internal.schema.constraints.RelationshipEndpointConstraintDescriptor;
import org.neo4j.internal.schema.constraints.RelationshipEndpointConstraintDescriptorImplementation;
import org.neo4j.internal.schema.constraints.TypeConstraintDescriptor;
import org.neo4j.internal.schema.constraints.UniquenessConstraintDescriptor;
import org.neo4j.util.VisibleForTesting;

public class ConstraintDescriptorFactory {
    private ConstraintDescriptorFactory() {
    }

    public static ExistenceConstraintDescriptor existsForSchema(SchemaDescriptor schema, boolean isDependent) {
        return ConstraintDescriptorImplementation.makeExistsConstraint(schema, isDependent);
    }

    public static UniquenessConstraintDescriptor uniqueForSchema(SchemaDescriptor schema) {
        return ConstraintDescriptorImplementation.makeUniqueConstraint(schema, IndexType.RANGE);
    }

    public static UniquenessConstraintDescriptor uniqueForSchema(SchemaDescriptor schema, IndexType indexType) {
        return ConstraintDescriptorImplementation.makeUniqueConstraint(schema, indexType);
    }

    public static KeyConstraintDescriptor keyForSchema(SchemaDescriptor schema) {
        return ConstraintDescriptorImplementation.makeUniqueExistsConstraint(schema, IndexType.RANGE);
    }

    public static KeyConstraintDescriptor keyForSchema(SchemaDescriptor schema, IndexType indexType) {
        return ConstraintDescriptorImplementation.makeUniqueExistsConstraint(schema, indexType);
    }

    public static TypeConstraintDescriptor typeForSchema(SchemaDescriptor schema, PropertyTypeSet allowedTypes, boolean isDependent) {
        return ConstraintDescriptorImplementation.makePropertyTypeConstraint(schema, allowedTypes, isDependent);
    }

    public static RelationshipEndpointConstraintDescriptor relationshipEndpointForSchema(SchemaDescriptor schema, int endpointLabelId, EndpointType endpointType) {
        return RelationshipEndpointConstraintDescriptorImplementation.make(schema, endpointLabelId, endpointType);
    }

    public static ExistenceConstraintDescriptor existsForLabel(boolean isDependent, int labelId, int ... propertyIds) {
        return ConstraintDescriptorFactory.existsForSchema(SchemaDescriptors.forLabel(labelId, propertyIds), isDependent);
    }

    public static ExistenceConstraintDescriptor existsForRelType(boolean isDependent, int relTypeId, int ... propertyIds) {
        return ConstraintDescriptorFactory.existsForSchema(SchemaDescriptors.forRelType(relTypeId, propertyIds), isDependent);
    }

    public static UniquenessConstraintDescriptor uniqueForLabel(int labelId, int ... propertyIds) {
        return ConstraintDescriptorFactory.uniqueForSchema(SchemaDescriptors.forLabel(labelId, propertyIds));
    }

    public static UniquenessConstraintDescriptor uniqueForLabel(IndexType indexType, int labelId, int ... propertyIds) {
        return ConstraintDescriptorFactory.uniqueForSchema(SchemaDescriptors.forLabel(labelId, propertyIds), indexType);
    }

    public static KeyConstraintDescriptor nodeKeyForLabel(int labelId, int ... propertyIds) {
        return ConstraintDescriptorFactory.keyForSchema(SchemaDescriptors.forLabel(labelId, propertyIds));
    }

    public static KeyConstraintDescriptor nodeKeyForLabel(IndexType indexType, int labelId, int ... propertyIds) {
        return ConstraintDescriptorFactory.keyForSchema(SchemaDescriptors.forLabel(labelId, propertyIds), indexType);
    }

    @VisibleForTesting
    public static RelationshipEndpointConstraintDescriptor relationshipEndpointForRelType(int relTypeId, int endpointLabelId, EndpointType endpointType) {
        return ConstraintDescriptorFactory.relationshipEndpointForSchema(SchemaDescriptors.forRelationshipEndpoint(relTypeId), endpointLabelId, endpointType);
    }
}

