/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.schema.constraints;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.NotImplementedException;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.map.ImmutableMap;
import org.eclipse.collections.impl.map.mutable.ConcurrentHashMap;
import org.neo4j.graphdb.schema.PropertyType;
import org.neo4j.internal.schema.constraints.ConstrainableType;
import org.neo4j.internal.schema.constraints.TypeRepresentation;
import org.neo4j.values.storable.Vector;

public final class VectorType
implements ConstrainableType {
    private static final String CYPHER_USER_DESCRIPTION = "VECTOR<%s>(%d)";
    private final Vector.CoordinateType coordinateType;
    private final int dimensions;
    private final TypeRepresentation.Ordering order;
    private static final ImmutableMap<Vector.CoordinateType, ConcurrentHashMap<Integer, VectorType>> INTERNED = Lists.fixedSize.with((Object[])Vector.CoordinateType.values()).toImmutableMap((Function & Serializable)c -> c, (Function & Serializable)c -> new ConcurrentHashMap());
    private static final String SERIALIZE_PATTERN = "VECTOR[coordinate=%s, dimensions=%d]";
    private static final Pattern DESERIALIZE_PATTERN = Pattern.compile("VECTOR\\[coordinate=(\\w+), dimensions=(\\d+)\\]");

    private VectorType(Vector.CoordinateType coordinateType, int dimensions) {
        if (dimensions < 1 || dimensions > 4096) {
            throw new IllegalArgumentException("Required %d <= %d <= %d".formatted(1, dimensions, 4096));
        }
        this.coordinateType = coordinateType;
        this.order = VectorType.toOrdering(coordinateType);
        this.dimensions = dimensions;
    }

    public int dimensions() {
        return this.dimensions;
    }

    public Vector.CoordinateType coordinateType() {
        return this.coordinateType;
    }

    public String toString() {
        return this.getClass().getName() + "[inner=%s, dimensions=%d]".formatted(this.coordinateType, this.dimensions);
    }

    public boolean equals(Object other) {
        return super.equals(other);
    }

    @Override
    public TypeRepresentation.Ordering order() {
        return this.order;
    }

    @Override
    public String userDescription() {
        return CYPHER_USER_DESCRIPTION.formatted(this.coordinateType.name(), this.dimensions);
    }

    public static VectorType int8Vector(int dimension) {
        return VectorType.getInterned(Vector.CoordinateType.INTEGER8, dimension);
    }

    public static VectorType int16Vector(int dimension) {
        return VectorType.getInterned(Vector.CoordinateType.INTEGER16, dimension);
    }

    public static VectorType int32Vector(int dimension) {
        return VectorType.getInterned(Vector.CoordinateType.INTEGER32, dimension);
    }

    public static VectorType int64Vector(int dimension) {
        return VectorType.getInterned(Vector.CoordinateType.INTEGER64, dimension);
    }

    public static VectorType float32Vector(int dimension) {
        return VectorType.getInterned(Vector.CoordinateType.FLOAT32, dimension);
    }

    public static VectorType float64Vector(int dimension) {
        return VectorType.getInterned(Vector.CoordinateType.FLOAT64, dimension);
    }

    @Override
    public PropertyType toPublicApi() {
        throw new NotImplementedException("Vectors are not yet represented in Public API");
    }

    private static TypeRepresentation.Ordering toOrdering(Vector.CoordinateType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case Vector.CoordinateType.INTEGER8 -> TypeRepresentation.Ordering.VECTOR_INT8_ORDER;
            case Vector.CoordinateType.INTEGER16 -> TypeRepresentation.Ordering.VECTOR_INT16_ORDER;
            case Vector.CoordinateType.INTEGER32 -> TypeRepresentation.Ordering.VECTOR_INT32_ORDER;
            case Vector.CoordinateType.INTEGER64 -> TypeRepresentation.Ordering.VECTOR_INT64_ORDER;
            case Vector.CoordinateType.FLOAT32 -> TypeRepresentation.Ordering.VECTOR_FLOAT32_ORDER;
            case Vector.CoordinateType.FLOAT64 -> TypeRepresentation.Ordering.VECTOR_FLOAT64_ORDER;
        };
    }

    private static VectorType getInterned(Vector.CoordinateType inner, int dimension) {
        ConcurrentHashMap map = (ConcurrentHashMap)INTERNED.get((Object)inner);
        assert (map != null);
        return (VectorType)map.computeIfAbsent((Object)dimension, ignored -> new VectorType(inner, dimension));
    }

    @Override
    public String serialize() {
        return SERIALIZE_PATTERN.formatted(this.coordinateType, this.dimensions);
    }

    public static VectorType deserialize(String str) throws IllegalArgumentException {
        Matcher matcher = DESERIALIZE_PATTERN.matcher(str);
        if (matcher.matches()) {
            return VectorType.getInterned(Vector.CoordinateType.valueOf((String)matcher.group(1)), Integer.parseInt(matcher.group(2)));
        }
        throw new IllegalArgumentException(str);
    }
}

