/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.router.transaction;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.neo4j.bolt.protocol.common.message.AccessMode;
import org.neo4j.bolt.protocol.common.message.request.connection.RoutingContext;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.fabric.transaction.StatementLifecycleTransactionInfo;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.database.NormalizedDatabaseName;
import org.neo4j.kernel.impl.query.QueryExecutionConfiguration;

public final class TransactionInfo {
    private final NormalizedDatabaseName sessionDatabaseName;
    private final KernelTransaction.Type type;
    private final LoginContext loginContext;
    private final ClientConnectionInfo clientInfo;
    private final List<String> bookmarks;
    private final Duration txTimeout;
    private final AccessMode accessMode;
    private Map<String, Object> txMetadata;
    private final RoutingContext routingContext;
    private final QueryExecutionConfiguration queryExecutionConfiguration;
    private final boolean isComposite;

    public TransactionInfo(NormalizedDatabaseName sessionDatabaseName, KernelTransaction.Type type, LoginContext loginContext, ClientConnectionInfo clientInfo, List<String> bookmarks, Duration txTimeout, AccessMode accessMode, Map<String, Object> txMetadata, RoutingContext routingContext, QueryExecutionConfiguration queryExecutionConfiguration, boolean isComposite) {
        this.sessionDatabaseName = sessionDatabaseName;
        this.type = type;
        this.loginContext = loginContext;
        this.clientInfo = clientInfo;
        this.bookmarks = bookmarks;
        this.txTimeout = txTimeout;
        this.accessMode = accessMode;
        this.txMetadata = txMetadata;
        this.routingContext = routingContext;
        this.queryExecutionConfiguration = queryExecutionConfiguration;
        this.isComposite = isComposite;
    }

    public TransactionInfo withDefaults(Config config) {
        return new TransactionInfo(this.sessionDatabaseName, this.type, this.loginContext, this.clientInfo, this.bookmarks, this.txTimeout != null ? this.txTimeout : (Duration)config.get(GraphDatabaseSettings.transaction_timeout), this.accessMode, this.txMetadata != null ? this.txMetadata : Collections.emptyMap(), this.routingContext, this.queryExecutionConfiguration, this.isComposite);
    }

    public StatementLifecycleTransactionInfo statementLifecycleTransactionInfo() {
        return new StatementLifecycleTransactionInfo(this.loginContext, this.clientInfo, this.txMetadata);
    }

    public void setTxMetadata(Map<String, Object> txMeta) {
        this.txMetadata = txMeta;
    }

    public NormalizedDatabaseName sessionDatabaseName() {
        return this.sessionDatabaseName;
    }

    public KernelTransaction.Type type() {
        return this.type;
    }

    public LoginContext loginContext() {
        return this.loginContext;
    }

    public ClientConnectionInfo clientInfo() {
        return this.clientInfo;
    }

    public List<String> bookmarks() {
        return this.bookmarks;
    }

    public Duration txTimeout() {
        return this.txTimeout;
    }

    public AccessMode accessMode() {
        return this.accessMode;
    }

    public Map<String, Object> txMetadata() {
        return this.txMetadata;
    }

    public RoutingContext routingContext() {
        return this.routingContext;
    }

    public QueryExecutionConfiguration queryExecutionConfiguration() {
        return this.queryExecutionConfiguration;
    }

    public boolean isComposite() {
        return this.isComposite;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        TransactionInfo that = (TransactionInfo)obj;
        return Objects.equals(this.sessionDatabaseName, that.sessionDatabaseName) && Objects.equals(this.type, that.type) && Objects.equals(this.loginContext, that.loginContext) && Objects.equals(this.clientInfo, that.clientInfo) && Objects.equals(this.bookmarks, that.bookmarks) && Objects.equals(this.txTimeout, that.txTimeout) && Objects.equals(this.accessMode, that.accessMode) && Objects.equals(this.txMetadata, that.txMetadata) && Objects.equals(this.routingContext, that.routingContext) && Objects.equals(this.queryExecutionConfiguration, that.queryExecutionConfiguration);
    }

    public int hashCode() {
        return Objects.hash(this.sessionDatabaseName, this.type, this.loginContext, this.clientInfo, this.bookmarks, this.txTimeout, this.accessMode, this.txMetadata, this.routingContext, this.queryExecutionConfiguration);
    }

    public String toString() {
        return "TransactionInfo[sessionDatabaseName=" + this.sessionDatabaseName + ", type=" + this.type + ", loginContext=" + this.loginContext + ", clientInfo=" + this.clientInfo + ", bookmarks=" + this.bookmarks + ", txTimeout=" + this.txTimeout + ", accessMode=" + this.accessMode + ", txMetadata=" + this.txMetadata + ", routingContext=" + this.routingContext + ", queryExecutionConfiguration=" + this.queryExecutionConfiguration + "]";
    }
}

