/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.router.impl.query.parsing;

import java.util.List;
import java.util.Optional;
import org.neo4j.cypher.internal.PreParsedQuery;
import org.neo4j.cypher.internal.PreParser;
import org.neo4j.cypher.internal.ast.AdministrationCommand;
import org.neo4j.cypher.internal.ast.CatalogName;
import org.neo4j.cypher.internal.ast.Statement;
import org.neo4j.cypher.internal.compiler.CypherParsing;
import org.neo4j.cypher.internal.compiler.helpers.SignatureResolver;
import org.neo4j.cypher.internal.frontend.phases.BaseState;
import org.neo4j.cypher.internal.frontend.phases.CompilationPhaseTracer;
import org.neo4j.cypher.internal.options.CypherQueryOptions;
import org.neo4j.cypher.internal.planner.spi.ProcedureSignatureResolver;
import org.neo4j.cypher.internal.tracing.CompilationTracer;
import org.neo4j.cypher.internal.util.CancellationChecker;
import org.neo4j.cypher.internal.util.InternalNotificationLogger;
import org.neo4j.cypher.internal.util.RecordingNotificationLogger;
import org.neo4j.fabric.eval.StaticUseEvaluation;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.api.procedure.ProcedureView;
import org.neo4j.router.impl.query.StatementType;
import org.neo4j.router.query.Query;
import org.neo4j.router.query.QueryPreParsedInfoParser;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.jdk.javaapi.CollectionConverters;
import scala.jdk.javaapi.OptionConverters;

public class StandardQueryPreParser
implements QueryPreParsedInfoParser {
    public static final CatalogName SYSTEM_DATABASE_CATALOG_NAME = CatalogName.of((String)"system");
    private final QueryPreParsedInfoParser.Cache cache;
    private final PreParser preParser;
    private final CypherParsing parsing;
    private final CompilationTracer tracer;
    private final CancellationChecker cancellationChecker;
    private final GlobalProcedures globalProcedures;
    private final StaticUseEvaluation staticUseEvaluation = new StaticUseEvaluation();

    public StandardQueryPreParser(QueryPreParsedInfoParser.Cache cache, PreParser preParser, CypherParsing parsing, CompilationTracer tracer, CancellationChecker cancellationChecker, GlobalProcedures globalProcedures) {
        this.cache = cache;
        this.preParser = preParser;
        this.parsing = parsing;
        this.tracer = tracer;
        this.cancellationChecker = cancellationChecker;
        this.globalProcedures = globalProcedures;
    }

    @Override
    public QueryPreParsedInfoParser.PreParsedInfo parseQuery(Query query) {
        return this.cache.computeIfAbsent(query.text(), () -> this.doParseQuery(query));
    }

    @Override
    public long clearQueryCachesForDatabase(String databaseName) {
        return this.cache.clearQueryCachesForDatabase(databaseName);
    }

    private QueryPreParsedInfoParser.PreParsedInfo doParseQuery(Query query) {
        CompilationTracer.QueryCompilationEvent queryTracer = this.tracer.compileQuery(query.text());
        RecordingNotificationLogger notificationLogger = new RecordingNotificationLogger();
        PreParsedQuery preParsedQuery = this.preParser.preParse(query.text(), (InternalNotificationLogger)notificationLogger);
        BaseState parsedQuery = this.parse(query, queryTracer, preParsedQuery);
        return this.preParsedInfo(parsedQuery, preParsedQuery.options().queryOptions());
    }

    private BaseState parse(Query query, CompilationTracer.QueryCompilationEvent queryTracer, PreParsedQuery preParsedQuery) {
        return this.parsing.parseQuery(preParsedQuery.statement(), preParsedQuery.rawStatement(), (InternalNotificationLogger)new RecordingNotificationLogger(), preParsedQuery.options().queryOptions().planner().name(), Option.apply((Object)preParsedQuery.options().offset()), (CompilationPhaseTracer)queryTracer, query.parameters(), this.cancellationChecker);
    }

    private QueryPreParsedInfoParser.PreParsedInfo preParsedInfo(BaseState parsedQuery, CypherQueryOptions cypherQueryOptions) {
        Statement statement = parsedQuery.statement();
        Optional obfuscationMetadata = OptionConverters.toJava((Option)parsedQuery.maybeObfuscationMetadata());
        SignatureResolver resolver = SignatureResolver.from((ProcedureView)this.globalProcedures.getCurrentView());
        if (statement instanceof AdministrationCommand) {
            return new QueryPreParsedInfoParser.PreParsedInfo(new QueryPreParsedInfoParser.SingleQueryCatalogInfo(Optional.of(SYSTEM_DATABASE_CATALOG_NAME)), obfuscationMetadata, StatementType.of(statement, (ProcedureSignatureResolver)resolver), cypherQueryOptions.executionMode());
        }
        Seq graphSelections = this.staticUseEvaluation.evaluateStaticTopQueriesGraphSelections(statement);
        QueryPreParsedInfoParser.CatalogInfo catalogInfo = this.toCatalogInfo((Seq<Option<CatalogName>>)graphSelections);
        return new QueryPreParsedInfoParser.PreParsedInfo(catalogInfo, obfuscationMetadata, StatementType.of(statement, (ProcedureSignatureResolver)resolver), cypherQueryOptions.executionMode());
    }

    private QueryPreParsedInfoParser.CatalogInfo toCatalogInfo(Seq<Option<CatalogName>> graphSelections) {
        if (graphSelections.size() == 1) {
            return new QueryPreParsedInfoParser.SingleQueryCatalogInfo(OptionConverters.toJava((Option)((Option)graphSelections.head())));
        }
        List<Optional<CatalogName>> catalogNames = CollectionConverters.asJava(graphSelections).stream().map(OptionConverters::toJava).toList();
        return new QueryPreParsedInfoParser.UnionQueryCatalogInfo(catalogNames);
    }
}

