/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.router.impl.query;

import java.util.Optional;
import org.neo4j.cypher.internal.ast.CatalogName;
import org.neo4j.exceptions.InvalidSemanticsException;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.router.impl.query.AbstractQueryPreParsedInfoService;
import org.neo4j.router.query.DatabaseReferenceResolver;
import org.neo4j.router.query.QueryPreParsedInfoParser;

public class StandardQueryPreParsedInfoService
extends AbstractQueryPreParsedInfoService {
    private final DatabaseReferenceResolver databaseReferenceResolver;

    public StandardQueryPreParsedInfoService(DatabaseReference sessionDatabase, DatabaseReferenceResolver databaseReferenceResolver) {
        super(sessionDatabase);
        this.databaseReferenceResolver = databaseReferenceResolver;
    }

    @Override
    public DatabaseReference target(QueryPreParsedInfoParser.PreParsedInfo preParsedInfo) {
        Optional<DatabaseReference> parsedTarget = this.toCatalogName(preParsedInfo.catalogInfo()).map(CatalogName::qualifiedNameString).map(this.databaseReferenceResolver::resolve);
        if (parsedTarget.filter(target -> target.isComposite() || !target.isPrimary() && target.namespace().isPresent()).isPresent()) {
            String message = "Accessing a composite database and its constituents is only allowed when connected to it. Attempted to access '%s' while connected to '%s'";
            throw new InvalidSemanticsException(String.format(message, parsedTarget.get().toPrettyString(), this.sessionDatabase.toPrettyString()));
        }
        return parsedTarget.orElse(this.sessionDatabase);
    }

    private Optional<CatalogName> toCatalogName(QueryPreParsedInfoParser.CatalogInfo catalogInfo) {
        if (catalogInfo instanceof QueryPreParsedInfoParser.SingleQueryCatalogInfo) {
            QueryPreParsedInfoParser.SingleQueryCatalogInfo singleQueryCatalogInfo = (QueryPreParsedInfoParser.SingleQueryCatalogInfo)catalogInfo;
            return singleQueryCatalogInfo.catalogName();
        }
        if (catalogInfo instanceof QueryPreParsedInfoParser.UnionQueryCatalogInfo) {
            QueryPreParsedInfoParser.UnionQueryCatalogInfo unionQueryCatalogInfo = (QueryPreParsedInfoParser.UnionQueryCatalogInfo)catalogInfo;
            Optional<CatalogName> catalogName = unionQueryCatalogInfo.catalogNames().get(0);
            if (catalogName.isPresent() && unionQueryCatalogInfo.catalogNames().stream().anyMatch(Optional::isEmpty) && !this.sessionDatabase.fullName().name().equals(catalogName.get().qualifiedNameString())) {
                throw new InvalidSemanticsException("Using multiple graphs in the same query is not supported on standard databases. This capability is supported on composite databases only.");
            }
            return catalogName;
        }
        throw new IllegalArgumentException("Unexpected catalog info " + catalogInfo);
    }
}

