/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.router.impl.transaction.database;

import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.neo4j.bolt.protocol.common.message.AccessMode;
import org.neo4j.common.DependencyResolver;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseContextProvider;
import org.neo4j.fabric.bookmark.LocalGraphTransactionIdTracker;
import org.neo4j.fabric.bookmark.TransactionBookmarkManager;
import org.neo4j.fabric.executor.Location;
import org.neo4j.graphdb.TransactionFailureHelper;
import org.neo4j.internal.kernel.api.connectioninfo.RoutingInfo;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.availability.UnavailableException;
import org.neo4j.kernel.database.DatabaseReferenceImpl;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.factory.KernelTransactionFactory;
import org.neo4j.kernel.impl.query.ConstituentTransactionFactory;
import org.neo4j.kernel.impl.query.Neo4jTransactionalContextFactory;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.kernel.impl.query.TransactionalContextFactory;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;
import org.neo4j.router.QueryRouterException;
import org.neo4j.router.impl.transaction.database.LocalDatabaseTransaction;
import org.neo4j.router.transaction.DatabaseTransaction;
import org.neo4j.router.transaction.DatabaseTransactionFactory;
import org.neo4j.router.transaction.TransactionInfo;

public class LocalDatabaseTransactionFactory
implements DatabaseTransactionFactory<Location.Local> {
    protected final DatabaseContextProvider<?> databaseContextProvider;
    protected final LocalGraphTransactionIdTracker transactionIdTracker;

    public LocalDatabaseTransactionFactory(DatabaseContextProvider<?> databaseContextProvider, LocalGraphTransactionIdTracker transactionIdTracker) {
        this.databaseContextProvider = databaseContextProvider;
        this.transactionIdTracker = transactionIdTracker;
    }

    @Override
    public DatabaseTransaction beginTransaction(Location.Local location, TransactionInfo transactionInfo, TransactionBookmarkManager bookmarkManager, Consumer<Status> terminationCallback, ConstituentTransactionFactory constituentTransactionFactory) {
        DatabaseContext databaseContext = (DatabaseContext)this.databaseContextProvider.getDatabaseContext(location.databaseReference().databaseId()).orElseThrow(LocalDatabaseTransactionFactory.databaseUnavailable(location.getDatabaseName()));
        GraphDatabaseAPI databaseApi = databaseContext.databaseFacade();
        DependencyResolver resolver = databaseContext.dependencies();
        try {
            databaseContext.database().getDatabaseAvailabilityGuard().assertDatabaseAvailable();
        }
        catch (UnavailableException e) {
            throw QueryRouterException.wrapError(e);
        }
        QueryExecutionEngine queryExecutionEngine = (QueryExecutionEngine)resolver.resolveDependency(QueryExecutionEngine.class);
        TransactionalContextFactory transactionalContextFactory = this.getTransactionalContextFactory(location, resolver, this.dbMode(location));
        bookmarkManager.getBookmarkForLocal(location).ifPresent(bookmark -> this.transactionIdTracker.awaitGraphUpToDate(location, bookmark.transactionId()));
        InternalTransaction internalTransaction = this.beginInternalTransaction(databaseApi, transactionInfo, terminationCallback);
        return new LocalDatabaseTransaction(location, transactionInfo, internalTransaction, transactionalContextFactory, queryExecutionEngine, bookmarkManager, this.transactionIdTracker, constituentTransactionFactory);
    }

    protected TransactionalContextFactory getTransactionalContextFactory(Location.Local location, DependencyResolver resolver, TransactionalContext.DatabaseMode dbMode) {
        return Neo4jTransactionalContextFactory.create((Supplier)resolver.provideDependency(GraphDatabaseQueryService.class), (KernelTransactionFactory)((KernelTransactionFactory)resolver.resolveDependency(KernelTransactionFactory.class)), (TransactionalContext.DatabaseMode)dbMode);
    }

    protected InternalTransaction beginInternalTransaction(GraphDatabaseAPI databaseApi, TransactionInfo transactionInfo, Consumer<Status> terminationCallback) {
        RoutingInfo.AccessMode accessMode = switch (transactionInfo.accessMode()) {
            default -> throw new MatchException(null, null);
            case AccessMode.WRITE -> RoutingInfo.AccessMode.WRITE;
            case AccessMode.READ -> RoutingInfo.AccessMode.READ;
        };
        RoutingInfo routingInfo = new RoutingInfo(accessMode, transactionInfo.routingContext().getParameters());
        InternalTransaction internalTransaction = databaseApi.beginTransaction(transactionInfo.type(), transactionInfo.loginContext(), transactionInfo.clientInfo(), routingInfo, transactionInfo.bookmarks(), transactionInfo.txTimeout().toMillis(), TimeUnit.MILLISECONDS, terminationCallback, this::transformTerminalOperationError);
        internalTransaction.setMetaData(transactionInfo.txMetadata());
        return internalTransaction;
    }

    private RuntimeException transformTerminalOperationError(Exception e, Log log) {
        if (e instanceof Status.HasStatus) {
            Status.HasStatus se = (Status.HasStatus)e;
            if (e instanceof RuntimeException) {
                RuntimeException re = (RuntimeException)e;
                return re;
            }
            return QueryRouterException.wrapError((Throwable)se);
        }
        log.error(e.getMessage(), (Throwable)e);
        throw TransactionFailureHelper.genericFailure((Throwable)e);
    }

    protected static Supplier<QueryRouterException> databaseUnavailable(String databaseNameRaw) {
        return () -> {
            UnavailableException unavailableException = UnavailableException.databaseUnavailable((String)databaseNameRaw, (String)String.format("Database %s not available", databaseNameRaw));
            return new QueryRouterException(unavailableException.gqlStatusObject(), unavailableException.status(), unavailableException.legacyMessage(), unavailableException);
        };
    }

    private TransactionalContext.DatabaseMode dbMode(Location.Local location) {
        if (location.databaseReference() instanceof DatabaseReferenceImpl.GraphShard) {
            return TransactionalContext.DatabaseMode.SHARDED;
        }
        return TransactionalContext.DatabaseMode.SINGLE;
    }
}

