/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.kernel.api.QueryLanguage;

class ProcedureHolder<T> {
    private final Map<QualifiedName, int[]> nameToEntries;
    private final Map<QualifiedName, int[]> caseInsensitiveName2Entries;
    private static int UNUSED_REFERENCE = -1;
    private final List<Object> store;
    private static final Object TOMBSTONE = new Object(){

        public String toString() {
            return "TOMBSTONE";
        }
    };

    public ProcedureHolder() {
        this(new HashMap<QualifiedName, int[]>(), new HashMap<QualifiedName, int[]>(), new ArrayList<Object>());
    }

    private ProcedureHolder(Map<QualifiedName, int[]> nameToId, Map<QualifiedName, int[]> caseInsensitiveName2Id, List<Object> store) {
        this.nameToEntries = nameToId;
        this.caseInsensitiveName2Entries = caseInsensitiveName2Id;
        this.store = store;
    }

    T getByKey(QualifiedName name, QueryLanguage scope) {
        int[] ids = this.name2entry(name);
        if (ids == null) {
            return null;
        }
        int reference = ids[scope.ordinal()];
        if (reference == UNUSED_REFERENCE) {
            return null;
        }
        Object value = this.store.get(reference);
        if (value == TOMBSTONE) {
            return null;
        }
        return (T)value;
    }

    T getById(int id) {
        Object element = this.store.get(id);
        if (element == TOMBSTONE) {
            return null;
        }
        return (T)element;
    }

    int put(QualifiedName name, Set<QueryLanguage> scopes, T item, boolean caseInsensitive) {
        int[] entry = this.name2entry(name);
        int reference = UNUSED_REFERENCE;
        if (entry != null) {
            if (ProcedureHolder.hasDifferentScopes(entry, scopes)) {
                reference = this.store.size();
                this.store.add(item);
                for (QueryLanguage scope : scopes) {
                    entry[scope.ordinal()] = reference;
                }
            } else {
                for (QueryLanguage scope : scopes) {
                    reference = entry[scope.ordinal()];
                    this.store.set(reference, item);
                }
            }
        } else {
            reference = this.store.size();
            entry = ProcedureHolder.makeEntry(scopes, reference);
            this.nameToEntries.put(name, entry);
            this.store.add(item);
        }
        QualifiedName lowercaseName = this.toLowerCaseName(name);
        if (caseInsensitive) {
            this.caseInsensitiveName2Entries.put(lowercaseName, entry);
        } else {
            this.caseInsensitiveName2Entries.remove(lowercaseName);
        }
        assert (reference != UNUSED_REFERENCE);
        return reference;
    }

    public static <T> ProcedureHolder<T> tombstone(ProcedureHolder<T> src, Predicate<QualifiedName> which) {
        Objects.requireNonNull(which);
        ProcedureHolder<T> ret = new ProcedureHolder<T>();
        IntHashSet matches = new IntHashSet();
        for (Map.Entry<QualifiedName, int[]> entry : src.nameToEntries.entrySet()) {
            if (!which.test(entry.getKey())) continue;
            matches.addAll(entry.getValue());
        }
        for (int i = 0; i < src.store.size(); ++i) {
            if (matches.contains(i)) {
                ret.store.add(TOMBSTONE);
                continue;
            }
            ret.store.add(src.store.get(i));
        }
        ret.caseInsensitiveName2Entries.putAll(src.caseInsensitiveName2Entries);
        ret.nameToEntries.putAll(src.nameToEntries);
        return ret;
    }

    int idOfKey(QualifiedName name, QueryLanguage scope) {
        int[] entry = this.name2entry(name);
        if (entry == null) {
            throw new NoSuchElementException();
        }
        int reference = entry[scope.ordinal()];
        if (reference == UNUSED_REFERENCE) {
            throw new NoSuchElementException();
        }
        if (this.store.get(reference) == TOMBSTONE) {
            throw new NoSuchElementException();
        }
        return reference;
    }

    void forEach(BiConsumer<Integer, T> consumer) {
        for (int i = 0; i < this.store.size(); ++i) {
            Object item = this.store.get(i);
            if (item == TOMBSTONE) continue;
            consumer.accept(i, (Integer)item);
        }
    }

    boolean contains(QualifiedName name, QueryLanguage scope) {
        return this.getByKey(name, scope) != null;
    }

    private int[] name2entry(QualifiedName name) {
        int[] entry = this.nameToEntries.get(name);
        if (entry == null) {
            QualifiedName lowerCaseName = this.toLowerCaseName(name);
            entry = this.caseInsensitiveName2Entries.get(lowerCaseName);
        }
        return entry;
    }

    private QualifiedName toLowerCaseName(QualifiedName name) {
        String[] oldNs = name.namespace();
        String[] lowerCaseNamespace = new String[oldNs.length];
        for (int i = 0; i < oldNs.length; ++i) {
            lowerCaseNamespace[i] = oldNs[i].toLowerCase(Locale.ROOT);
        }
        String lowercaseName = name.name().toLowerCase(Locale.ROOT);
        return new QualifiedName(lowerCaseNamespace, lowercaseName);
    }

    public void unregister(QualifiedName name) {
        int[] entry = this.name2entry(name);
        if (entry == null) {
            return;
        }
        for (int reference : entry) {
            if (reference == UNUSED_REFERENCE) continue;
            this.store.set(reference, TOMBSTONE);
        }
    }

    public static <T> ProcedureHolder<T> copyOf(ProcedureHolder<T> ref) {
        return new ProcedureHolder<T>(Map.copyOf(ref.nameToEntries), Map.copyOf(ref.caseInsensitiveName2Entries), List.copyOf(ref.store));
    }

    private static boolean hasDifferentScopes(int[] entry, Set<QueryLanguage> scopes) {
        for (QueryLanguage scope : QueryLanguage.ALL) {
            if (entry[scope.ordinal()] == UNUSED_REFERENCE || scopes.contains(scope)) continue;
            return true;
        }
        return false;
    }

    private static int[] makeEntry(Set<QueryLanguage> scopes, int reference) {
        int[] ids = new int[QueryLanguage.ALL.size()];
        for (QueryLanguage s : QueryLanguage.ALL) {
            if (scopes.contains(s)) {
                ids[s.ordinal()] = reference;
                continue;
            }
            ids[s.ordinal()] = UNUSED_REFERENCE;
        }
        return ids;
    }
}

